block('b-campaign-settings').elem('item').elemMod('of', 'brand-safety')(
    def()(function() {
        var campaign = this.data.campaign,
            cid = campaign.cid,
            ulogin = this.data.user_login,
            brandSafetyCategories = campaign.brandSafetyCategories || [],
            isEditable = this.mods.edit === 'yes',
            helpId = u.consts('isFeatureBrandSafetyAdditionalCategoriesEnabled') ?
                'brand-safety-extra' : 'brand-safety';

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'brand-safety', 'Brand Safety'),
                help: { url: u.getHelpUrl(helpId) }
            },
            right: [
                {
                    block: 'b-campaign-settings',
                    elem: 'brand-safety-control',
                    elemMods: {
                        readonly: isEditable ? '' : 'yes'
                    },
                    content: {
                        block: 'b-brand-safety',
                        mods: {
                            readonly: isEditable ? '' : 'yes'
                        },
                        brandSafetyCategories: brandSafetyCategories,
                        cid: cid,
                        ulogin: ulogin,
                        hiddenControlName: 'json_brandSafetyCategories',
                        modelParams: this.modelParams
                    }
                }
            ]
        };
    })
);
