block('b-campaign-settings').elem('item').elemMod('of', 'content-lang')(
    def()(''),

    def().match(function() {
        return hasLoginRights('super_control', 'superreader_control', 'limited_support_control');
    })(function() {
        var data = this.data,
            noLangSelectedLabel = '&mdash;',
            campaign = data.campaign,
            useBanner = campaign.mediaType == 'mcbanner';

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: useBanner ? iget2('b-campaign-settings', 'yazyk-bannerov', 'Язык баннеров') : iget2('b-campaign-settings', 'yazyk-obyavleniy', 'Язык объявлений')
            },
            right: this.mods.edit === 'yes' ?
                hasLoginRights('superreader_control', 'limited_support_control') ?
                    campaign.content_lang || noLangSelectedLabel :
                    {
                        block: 'select',
                        name: 'content_lang',
                        content: [
                            {
                                block: 'button',
                                content: campaign.content_lang
                            },
                            {
                                elem: 'control',
                                content: [{
                                    elem: 'option',
                                    attrs: {
                                        value: '',
                                        selected: !campaign.content_lang ? 'selected' : undefined
                                    },
                                    content: noLangSelectedLabel
                                }].concat(data.CAMPAIGN_CONTENT_LANGS.map(function(lang) {
                                    var option = {
                                        elem: 'option',
                                        attrs: {
                                            value: lang
                                        },
                                        content: lang
                                    };

                                    if (lang === campaign.content_lang) {
                                        option.attrs.selected = 'selected';
                                    }

                                    return option;
                                }))
                            }
                        ]
                    } :
                campaign.content_lang || iget2('b-campaign-settings', 'ne-vybran', 'Не выбран')
        };
    })
);
