block('b-campaign-settings')(

    elem('device-targeting').content()(function() {
        var deviceTargeting = this.ctx.deviceTargeting;

        return [
            {
                block: 'b-outboard-controls',
                elem: 'data-hint',
                mix: [{ block: 'b-campaign-settings', elem: 'hint' }],
                content: {
                    block: 'b-campaign-settings',
                    elem: 'device-targeting-text-wrap',
                    content: {
                        block: 'b-campaign-settings',
                        elem: 'device-targeting-text',
                        mix: [{ block: 'hint-row' }],
                        targeting: deviceTargeting
                    }
                }
            },
            {
                block: 'b-outboard-controls',
                mods: { modal: 'yes' },
                content: [
                    {
                        elem: 'switcher',
                        js: {
                            innerBlockParams: {
                                modelId: this.ctx.cid,
                                modelName: this.ctx.modelName
                            }
                        },
                        theme: 'normal',
                        switcherText: iget2('b-campaign-settings', 'izmenit', 'Изменить')
                    },
                    {
                        elem: 'popup',
                        header: iget2('b-campaign-settings', 'targeting-na-ustroystva', 'Таргетинг на устройства'),
                        autoclosable: 'no',
                        directions: ['bottom-left', 'right'],
                        innerBlock: { block: 'b-device-targeting' }
                    }
                ]
            },
            {
                block: 'b-campaign-settings',
                elem: 'hiddens',
                fields: { device_targeting: deviceTargeting }
            }
        ];
    }),

    elem('device-targeting-text').content()(function() {
        var devices = this.ctx.targeting.split(',');

        // все устройства, если пустая строка, или если там 5 устройств
        return devices.length == 5 || this.ctx.targeting === '' ?
            iget2('b-campaign-settings', 'vse-ustroystva', 'Все устройства') :
            devices.map(function(device) {
                // Просто переводим массив ключей девайсов в массив с человеко-понятными описаниями
                return {
                    other_devices: iget2('b-campaign-settings', 'stacionarnye-kompyutery-noutbuki-drugie', 'Стационарные компьютеры, ноутбуки, другие устройства'),
                    iphone: iget2('b-campaign-settings', 'iphone', 'iPhone'),
                    ipad: iget2('b-campaign-settings', 'ipad', 'iPad'),
                    android_phone: iget2('b-campaign-settings', 'smartfony-android', 'Смартфоны Android'),
                    android_tablet: iget2('b-campaign-settings', 'planshety-android', 'Планшеты Android')
                }[device];
            }).join(', ');
    })
);
