block('b-campaign-settings')(

    elem('disabled-ips').content()(function() {
        var disabledIps = this.ctx.disabledIps || '',
            disabledIpsText = u.escapeHTML(disabledIps).replace(/,/g, ', ');

        return [
            {
                block: 'b-outboard-controls',
                elem: 'data-hint',
                mix: [
                    {
                        block: 'b-campaign-settings',
                        elem: 'model-field',
                        js: {
                            name: 'disabledIps',
                            type: 'inline'
                        }
                    },
                    {
                        block: 'b-campaign-settings',
                        elem: 'hint'
                    }
                ],
                content: disabledIpsText
            },
            {
                block: 'b-outboard-controls',
                mix: { block: 'b-campaign-settings', elem: 'disabled-ips' },
                mods: { modal: 'yes' },
                content: [
                    {
                        elem: 'switcher',
                        js: { innerBlockParams: { modelParams: this.ctx.modelParams } },
                        theme: 'normal',
                        switcherText: disabledIps ? iget2('b-campaign-settings', 'izmenit', 'Изменить') : iget2('b-campaign-settings', 'dobavit', 'Добавить')
                    },
                    {
                        elem: 'popup',
                        header: this.ctx.useBanner ?
                            iget2('b-campaign-settings', 'ip-adresa-dlya-kotoryh', 'IP-адреса, для которых Вы запретили показы баннеров') :
                            iget2('b-campaign-settings', 'ip-adresa-dlya-kotoryh-110', 'IP-адреса, для которых Вы запретили показы объявлений'),
                        autoclosable: 'no',
                        innerBlock: {
                            block: 'b-disabled-ips',
                            disabledIps: disabledIps
                        }
                    }
                ]
            },
            {
                block: 'b-campaign-settings',
                elem: 'hiddens',
                fields: { disabledIps: disabledIps }
            }
        ];
    })
);
