block('b-campaign-settings').elem('item').elemMod('of', 'dont-show-video')(
    def()(''),

    def().match(function() {
        return u.consts('rights').allowedCpmVideoBanners;
    })(function() {
        var data = this.data,
            featuresEnabledForClient = data.features_enabled_for_client || {},
            campaign = data.campaign,
            platforms = (campaign.disabled_video_placements || []).map(u.escapeHTML),
            allowWhitelistedDomains = featuresEnabledForClient.disable_any_domains_allowed,
            requireFiltrationByDontShowDomains = !!(campaign.opts || {}).require_filtration_by_dont_show_domains,
            allowRequireFiltrationByDontShowDomain =
                featuresEnabledForClient.require_filtration_by_dont_show_domains ||
                (u.campaign.isCpm(campaign.mediaType) &&
                    featuresEnabledForClient.require_filtration_by_dont_show_domains_in_cpm);

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: this.ctx.title ||
                    iget2('b-campaign-settings', 'dont-show-video-label', 'Запрещённые площадки видеообъявлений')
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'b-outboard-controls',
                        mods: { modal: 'yes' },
                        mix: [
                            { block: 'b-campaign-settings', elem: 'dont-show-video' },
                            {
                                block: 'b-metrika2',
                                js: {
                                    goals: [
                                        {
                                            event: 'show',
                                            target: 'EditCamp.Show_advanced_settings.Blocked_sites.Popup'
                                        },
                                        {
                                            event: 'accept',
                                            target: 'EditCamp.Show_advanced_settings.Blocked_sites.Popup.Save'
                                        }
                                    ],
                                    blockName: 'b-outboard-controls'
                                }
                            }
                        ],
                        content: [
                            {
                                elem: 'data-hint',
                                mix: [
                                    {
                                        block: 'b-campaign-settings',
                                        elem: 'dont-show-video-wrap'
                                    },
                                    {
                                        block: 'b-campaign-settings',
                                        elem: 'hint'
                                    }
                                ],
                                content: {
                                    block: 'b-campaign-settings',
                                    elem: 'dont-show-hint',
                                    platforms: platforms,
                                    isEditable: true
                                }
                            },
                            {
                                elem: 'switcher',
                                js: {
                                    innerBlockParams: {
                                        modelParams: this.modelParams
                                    }
                                },
                                theme: 'normal',
                                switcherText: iget2('b-campaign-settings', 'dobavit', 'Добавить')
                            },
                            {
                                elem: 'popup',
                                header: iget2('b-campaign-settings', 'dont-show-domains-title', 'Площадки, на которых запрещены показы видеообъявлений'),
                                innerBlock: applyCtx({
                                    block: 'b-dont-show-domains',
                                    mods: { type: 'video' },
                                    needOuterNets: false,
                                    isMCBanner: false,
                                    isCpm: u.campaign.isCpm(campaign.mediaType),
                                    allowWhitelistedDomains: allowWhitelistedDomains,
                                    allowRequireFiltrationByDontShowDomain: allowRequireFiltrationByDontShowDomain,
                                    requireFiltrationByDontShowDomains: requireFiltrationByDontShowDomains
                                })
                            }
                        ]
                    },
                    {
                        block: 'b-campaign-settings',
                        elem: 'hidden',
                        elemMods: {
                            type: 'dont-show-video'
                        },
                        name: 'disabled_video_placements',
                        value: platforms.join(',')
                    }
                ] :
                {
                    block: 'b-campaign-settings',
                    elem: 'hint',
                    text: platforms
                }
        };
    })
);
