block('b-campaign-settings').elem('item').elemMod('of', 'dont-show')(
    def()(function() {
        var data = this.data,
            featuresEnabledForClient = data.features_enabled_for_client || {},
            campaign = data.campaign,
            isMCBanner = campaign.mediaType === 'mcbanner',
            isContentPromotion = campaign.mediaType === 'content_promotion',
            requireFiltrationByDontShowDomains = !!(campaign.opts || {}).require_filtration_by_dont_show_domains,
            platforms = [].concat(campaign.disabled_ssp, campaign.DontShow).map(u.escapeHTML),
            allowWhitelistedDomains = featuresEnabledForClient.disable_any_domains_allowed,
            allowRequireFiltrationByDontShowDomain =
                featuresEnabledForClient.require_filtration_by_dont_show_domains ||
                (u.campaign.isCpm(campaign.mediaType) &&
                    featuresEnabledForClient.require_filtration_by_dont_show_domains_in_cpm);

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: this.ctx.title || iget2('b-campaign-settings', 'zapreshchyonnye-ploshchadki-i-vneshnie', 'Запрещённые площадки и внешние сети'),
                help: !isMCBanner && !isContentPromotion ? {
                    url: u.getHelpUrl('blocked-sites'),
                    width: 1100
                } : undefined
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'b-outboard-controls',
                        mods: { modal: 'yes' },
                        mix: [
                            { block: 'b-campaign-settings', elem: 'dont-show' },
                            {
                                block: 'b-metrika2',
                                js: {
                                    goals: [
                                        {
                                            event: 'show',
                                            target: 'EditCamp.Show_advanced_settings.Blocked_sites.Popup'
                                        },
                                        {
                                            event: 'accept',
                                            target: 'EditCamp.Show_advanced_settings.Blocked_sites.Popup.Save'
                                        }
                                    ],
                                    blockName: 'b-outboard-controls'
                                }
                            }
                        ],
                        content: [
                            {
                                elem: 'data-hint',
                                mix: [
                                    {
                                        block: 'b-campaign-settings',
                                        elem: 'dont-show-wrap'
                                    },
                                    {
                                        block: 'b-campaign-settings',
                                        elem: 'hint'
                                    }
                                ],
                                content: {
                                    block: 'b-campaign-settings',
                                    elem: 'dont-show-hint',
                                    platforms: platforms,
                                    isEditable: true
                                }
                            },
                            {
                                elem: 'switcher',
                                js: {
                                    innerBlockParams: {
                                        modelParams: this.modelParams
                                    }
                                },
                                theme: 'normal',
                                switcherText: iget2('b-campaign-settings', 'dobavit', 'Добавить')
                            },
                            {
                                elem: 'popup',
                                header: iget2('b-campaign-settings', 'ploshchadki-na-kotoryh-zapreshcheny', 'Площадки, на которых запрещены показы объявлений'),
                                innerBlock: applyCtx({
                                    block: 'b-dont-show-domains',
                                    needOuterNets: this.ctx.needOuterNets,
                                    isMCBanner: isMCBanner,
                                    isContentPromotion: isContentPromotion,
                                    allowWhitelistedDomains: allowWhitelistedDomains,
                                    allowRequireFiltrationByDontShowDomain: allowRequireFiltrationByDontShowDomain,
                                    requireFiltrationByDontShowDomains: requireFiltrationByDontShowDomains
                                })
                            }
                        ]
                    },
                    {
                        block: 'b-campaign-settings',
                        elem: 'hidden',
                        elemMods: {
                            type: 'dont-show'
                        },
                        name: 'DontShow',
                        value: platforms.join(',')
                    },
                    allowRequireFiltrationByDontShowDomain == '1' && {
                        block: 'b-campaign-settings',
                        elem: 'hidden',
                        elemMods: {
                            type: 'require-filtration-by-dont-show-domains'
                        },
                        name: 'require_filtration_by_dont_show_domains',
                        value: requireFiltrationByDontShowDomains ? '1' : '0'
                    }
                ] :
                {
                    block: 'b-campaign-settings',
                    elem: 'hint',
                    text: platforms
                }
        };
    })
);
