block('b-campaign-settings').elem('item').elemMod('of', 'eshows-video')(
    def()(function() {
        var data = this.data,
            isNew = data.new_camp,
            campaign = data.campaign,
            isEditCamp = this.mods.edit === 'yes',
            eshowsVideoRate = campaign.eshows_video_rate,
            eshowsVideoType = campaign.eshows_video_type,
            eshowsVideoTypes = {
                long_clicks: iget2(
                    'b-campaign-settings',
                    'eshows-video-type-long-clicks',
                    'Максимизация переходов на сайт'
                ),
                completes: iget2(
                    'b-campaign-settings',
                    'eshows-video-type-completes',
                    'Максимизация досмотров видео'
                )
            };

        return {
            mixes: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: [
                {
                    block: 'checkbox',
                    mods: {
                        disabled: (isEditCamp && isNew) ? '' : 'yes',
                        checked: eshowsVideoRate ? 'yes' : ''
                    },
                    mix: { block: 'b-campaign-settings', elem: 'eshows-video-rate-checkbox' },
                    text: {
                        content: [
                            iget2(
                                'b-campaign-settings',
                                'eshows-video-rate',
                                'Для видео рекламы'
                            )
                        ]
                    }
                }
            ],
            right: [
                {
                    block: 'select',
                    mix: [
                        {
                            block: 'b-campaign-settings',
                            elem: 'model-field',
                            js: {
                                name: 'eshows_video_type',
                                type: 'select'
                            }
                        },
                        {
                            block: 'b-campaign-settings',
                            elem: 'eshows-video-type-input'
                        }
                    ],
                    mods: {
                        theme: 'normal',
                        size: 's',
                        disabled: !isNew || !eshowsVideoRate
                    },
                    content: [
                        {
                            block: 'button',
                            mix: [
                                {
                                    block: 'b-campaign-settings',
                                    elem: 'eshows-video-type-select-button'
                                }
                            ],
                            content: '&nbsp;'
                        },
                        {
                            elem: 'control',
                            attrs: {
                                name: 'eshows_video_type',
                                value: eshowsVideoType
                            },
                            content: Object.keys(eshowsVideoTypes).map(function(type) {
                                return {
                                    elem: 'option',
                                    attrs: {
                                        value: type,
                                        selected: eshowsVideoType === type
                                    },
                                    content: eshowsVideoTypes[type]
                                };
                            })
                        }
                    ]
                },
                {
                    block: 'b-campaign-settings',
                    elem: 'hiddens',
                    fields: { eshows_video_rate: eshowsVideoRate }
                }
            ]
        };
    })
);
