block('b-campaign-settings').elem('item').elemMod('of', 'extended-geotargeting')(
    def()(function() {
        var isMCBanner = this.data.campaign.mediaType === 'mcbanner';

        return {
            mixes: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: [
                {
                    block: 'checkbox',
                    mods: {
                        size: 's',
                        checked: this.data.campaign.no_extended_geotargeting ? '' : 'yes',
                        disabled: this.mods.edit === 'yes' ? undefined : 'yes'
                    },
                    mix: [{
                        block: 'b-metrika2',
                        js: {
                            event: 'change',
                            params: {
                                EditCamp: {
                                    Extended_geotargeting: 'Enabled'
                                }
                            },
                            blockName: 'checkbox'
                        }
                    }],
                    checkboxAttrs: {
                        name: 'extended_geotargeting',
                        value: 1
                    },
                    text: iget2('b-campaign-settings', 'rasshirennyy-geograficheskiy-targeting', 'Расширенный географический таргетинг')
                },
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    stretched: true,
                    width: 1100,
                    url: u.getHelpUrl(isMCBanner ? 'geotargeting-mode-search' : 'geotargeting-mode')
                }
            ]
        };
    })
);
