block('b-campaign-settings').elem('item').elemMod('of', 'geo').def()(function() {
    var data = this.data,
        isEditable = this.mods.edit === 'yes' || u.consts('rights').campaignSettingsWidgetsForSuperEnabled;

    return {
        mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
        left: {
            block: 'b-campaign-settings',
            elem: 'label',
            text: [
                iget2('b-campaign-settings', 'region-pokazov', 'Регион показов'),
                '&nbsp;',
                {
                    block: 'b-mark-required'
                }
            ],
            help: {
                url: u.getHelpUrl('geotargeting'),
                width: 1100,
                hintElem: 'hint-geo'
            }
        },
        right: applyCtx({
            block: 'b-campaign-region',
            mix: isEditable ?
                {
                    block: 'b-metrika2',
                    js: {
                        items: [
                            {
                                event: 'popup-show',
                                params: {
                                    EditCamp: {
                                        Display_region: 'Popup'
                                    }
                                }
                            },
                            {
                                event: 'save-click',
                                params: {
                                    EditCamp: {
                                        Display_region: {
                                            Popup: 'Save'
                                        }
                                    }
                                }
                            }
                        ],
                        blockName: 'b-campaign-region'
                    }
                } :
                {},
            campaign: data.campaign,
            hintAboveControl: true,
            hintMixes: [{ block: 'b-campaign-settings', elem: 'hint' }],
            isEditable: isEditable,
            withCommonGeoValidation: !(data.new_camp || data.continue_creating || u.consts('rights').campaignSettingsWidgetsForSuperEnabled),
            js: isEditable
        })
    };
});
