block('b-campaign-settings').elem('item').elemMod('of', 'impression-standard')(
    def()(function() {
        var data = this.data,
            isNew = data.new_camp,
            campaign = data.campaign,
            isEditCamp = this.mods.edit === 'yes',
            impressionStandards = {
                mrc: iget2(
                    'b-campaign-settings',
                    'mrc-impression-standard',
                    'MRC'
                ),
                yandex: iget2(
                    'b-campaign-settings',
                    'yandex-impression-standard',
                    'Яндекс'
                )
            },
            impressionStandardTime = campaign.impression_standard_time || '';

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: [
                    iget2(
                        'b-campaign-settings',
                        'impression-standard',
                        'Стандарт видимости '
                    )
                ],
                required: true
            },
            right: isEditCamp ? [
                {
                    block: 'select',
                    mix: [
                        {
                            block: 'b-campaign-settings',
                            elem: 'model-field',
                            js: {
                                name: 'impression_standard_time',
                                type: 'select'
                            }
                        },
                        {
                            block: 'b-campaign-settings',
                            elem: 'impression-standard-input'
                        }
                    ],
                    mods: {
                        theme: 'normal',
                        size: 's',
                        disabled: !isNew
                    },
                    content: [
                        {
                            block: 'button',
                            mix: [
                                {
                                    block: 'b-campaign-settings',
                                    elem: 'impression-standard-select-button'
                                }
                            ],
                            content: '&nbsp;'
                        },
                        {
                            elem: 'control',
                            attrs: {
                                name: 'impression_standard_time',
                                value: impressionStandardTime
                            },
                            content: Object.keys(impressionStandards).map(function(standard) {
                                return {
                                    elem: 'option',
                                    attrs: {
                                        value: standard,
                                        selected: impressionStandardTime === standard
                                    },
                                    content: impressionStandards[standard]
                                };
                            })
                        }
                    ]
                },
                {
                    block: 'b-model-form-error',
                    mix: [{
                        block: 'b-model-form-error',
                        elem: 'control'
                    }],
                    modelParams: this.modelParams,
                    field: 'impression_standard_time'
                }
            ] : impressionStandardTime ? impressionStandards[impressionStandardTime] : ''
        };
    })
);
