block('b-campaign-settings').elem('item').elemMod('of', 'internal-is-mobile')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: [
                    iget2('b-campaign-settings', 'internal-is-mobile', 'Реклама мобильного приложения'),
                    '&nbsp;',
                    {
                        block: 'b-mark-required'
                    }
                ]
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'radio-button',
                        mix: [
                            {
                                block: 'b-campaign-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'is_mobile',
                                    type: 'radio-button',
                                }
                            },
                            {
                                block: 'b-campaign-settings',
                                elem: 'internal-is-mobile-radio'
                            }
                        ],
                        name: 'is_mobile',
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: { value: '1' },
                                content: iget2('b-campaign-settings', 'internal-is-mobile-yes', 'Да')
                            },
                            {
                                elem: 'radio',
                                controlAttrs: { value: '0' },
                                content: iget2('b-campaign-settings', 'internal-is-mobile-no', 'Нет')
                            }
                        ],
                        value: campaign.is_mobile || ''
                    },
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'control'
                        }],
                        modelParams: this.modelParams,
                        field: 'is_mobile'
                    }
                ] : (campaign.is_mobile === '1' ?
                    iget2('b-campaign-settings', 'internal-is-mobile-yes', 'Да') :
                    iget2('b-campaign-settings', 'internal-is-mobile-no', 'Нет'))
        };
    })
);
