block('b-campaign-settings').elem('item').elemMod('of', 'internal-place-id')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            places = data.internal_ad_places;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: [
                    iget2('b-campaign-settings', 'internal-place-id', 'Place id'),
                    '&nbsp;',
                    {
                        block: 'b-mark-required'
                    }
                ]
            },
            right: this.mods.edit === 'yes' && !campaign.cid ?
                [
                    {
                        block: 'select',
                        mix: [
                            {
                                block: 'b-campaign-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'place_id',
                                    type: 'select'
                                }
                            },
                            {
                                block: 'b-campaign-settings',
                                elem: 'internal-place-id-input'
                            }
                        ],
                        mods: { theme: 'normal', size: 's' },
                        content: [
                            {
                                block: 'button',
                                mix: [
                                    {
                                        block: 'b-campaign-settings',
                                        elem: 'internal-place-id-select-button'
                                    }
                                ],
                                content: '&nbsp;'
                            },
                            {
                                elem: 'control',
                                attrs: {
                                    name: 'place_id',
                                    value: campaign.place_id || ''
                                },
                                content: [{ place_id: '0', place_description: '' }]
                                    .concat(
                                        places
                                            .slice()
                                            .sort(function(a, b) { return a.place_id - b.place_id })
                                    )
                                    .map(function(place) {
                                        var option = {
                                            elem: 'option',
                                            attrs: { value: place.place_id },
                                            content: '&nbsp;'
                                        };

                                        if (place.place_id !== '0' && place.place_description) {
                                            option.content = [place.place_id, place.place_description].join(': ');
                                        }

                                        if (place.place_id === campaign.place_id || !campaign.place_id && place.place_id === '') {
                                            option.attrs.selected = true;
                                        }

                                        return option;
                                    })
                            }
                        ]
                    },
                    {
                        block: 'b-model-form-error',
                        mix: [{
                            block: 'b-model-form-error',
                            elem: 'control'
                        }],
                        modelParams: this.modelParams,
                        field: 'place_id'
                    }
                ] : campaign.place_id || ''
        };
    })
);
