block('b-campaign-settings').elem('item').elemMod('of', 'internal-restriction-type')(
    def()(function() {
        var campaign = this.data.campaign,
            types = {
                shows: iget2('b-campaign-settings', 'internal-restriction-type-shows', 'Показы'),
                clicks: iget2('b-campaign-settings', 'internal-restriction-type-clicks', 'Клики'),
                days: iget2('b-campaign-settings', 'internal-restriction-type-days', 'Дни')
            };

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: [
                    iget2('b-campaign-settings', 'internal-restriction-type', 'Единица измерения'),
                    '&nbsp;',
                    {
                        block: 'b-mark-required'
                    }
                ]
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'radio-button',
                        mix: [
                            {
                                block: 'b-campaign-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'restriction_type',
                                    type: 'radio-button'
                                }
                            },
                            {
                                block: 'b-campaign-settings',
                                elem: 'internal-restriction-type-radio'
                            }
                        ],
                        name: 'restriction_type',
                        value: campaign.restriction_type,
                        content: Object.keys(types).map(function(type) {
                            return {
                                elem: 'radio',
                                controlAttrs: {
                                    value: type
                                },
                                content: types[type]
                            }
                        })
                    }
                ] :
                types[campaign.restriction_type]
        };
    })
);
