block('b-campaign-settings').elem('item').elemMod('of', 'internal-restriction')(
    def()(''),

    def().match(function() {
        return Boolean(this.data.campaign.restriction_type);
    })(function() {
        var campaign = this.data.campaign,
            getRestrictionTextByType = {
                shows: function(count) {
                    return u.pluralize([
                        iget2('b-campaign-settings', 'internal-restriction-type-shows-one', 'показ'),
                        iget2('b-campaign-settings', 'internal-restriction-type-shows-many', 'показа'),
                        iget2('b-campaign-settings', 'internal-restriction-type-shows-a-lot', 'показов')
                    ], count);
                },
                clicks: function(count) {
                    return u.pluralize([
                        iget2('b-campaign-settings', 'internal-restriction-type-clicks-one', 'клик'),
                        iget2('b-campaign-settings', 'internal-restriction-type-clicks-many', 'клика'),
                        iget2('b-campaign-settings', 'internal-restriction-type-clicks-a-lot', 'кликов')
                    ], count);
                },
                days: function(count) {
                    return u.pluralize([
                        iget2('b-campaign-settings', 'internal-restriction-type-days-one', 'день'),
                        iget2('b-campaign-settings', 'internal-restriction-type-days-many', 'дня'),
                        iget2('b-campaign-settings', 'internal-restriction-type-days-a-lot', 'дней')
                    ], count);
                }
            }[campaign.restriction_type];

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'internal-restriction', 'Ограничения')
            },
            right: getRestrictionTextByType(Number(campaign.restriction_value))
        };
    })
);
