block('b-campaign-settings').elem('item').elemMod('of', 'metrics-attribution')(

    def()(''),

    def().match(function() {
        var campaign = this.data.campaign || {},
            mediaType = campaign.mediaType;

        return !u['attribution-model'].isNewPolicyEnabled(mediaType) && u.access.modelAttributionEdit(this.data.login_rights);
    })(function() {
        var data = this.data,
            campaign = data.campaign || {},
            attributionModels = [
                { name: iget2('b-campaign-settings', 'last-direct-click', 'Последний переход из Яндекс.Директа'), id: 'last_yandex_direct_click' },
                { name: iget2('b-campaign-settings', 'last-significant-click', 'Последний значимый переход'), id: 'last_significant_click' },
                { name: iget2('b-campaign-settings', 'last-click', 'Последний переход'), id: 'last_click' }
            ],
            defaultValue = 'last_yandex_direct_click';
        if (!u.campaign.isInternal(campaign.mediaType)) {
            attributionModels.push({ name: iget2('b-campaign-settings', 'first-click', 'Первый переход'), id: 'first_click' });
        }

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'attribution-model', 'Модели атрибуции'),
                help: {
                    width: 1100,
                    url: u.getHelpUrl('attribution-model')
                }
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'select',
                        name: 'attribution_model',
                        mix: [{
                            block: 'b-campaign-settings',
                            elem: 'metrics-attribution-select'
                        }],
                        content: [
                            {
                                block: 'button'
                            },
                            {
                                elem: 'control',
                                content: attributionModels.map(function(model) {
                                    var currModel = campaign.attribution_model || defaultValue,
                                        attrs = {
                                            value: model.id,
                                            selected: model.id === currModel ? 'selected' : undefined
                                        };

                                    return {
                                        elem: 'option',
                                        attrs: attrs,
                                        content: model.name
                                    };
                                })
                            }
                        ]
                    }
                ] :
                campaign.attribution_model ?
                    u._.get(u._.find(attributionModels, 'id', campaign.attribution_model), 'name') :
                    iget2('b-campaign-settings', 'attribution-not-set', 'Не заданы')
        };
    })
);
