block('b-campaign-settings')(
    /**
     * Элемент выбора счётчиков метрики для кампании
     *
     * @param {Object} ctx.campaign объект кампании
     * @param {String} ctx.campaign.mediaType тип кампании
     * @param {String} ctx.campaign.metrika_counters счётчики метрики кампании
     * @param {Object} ctx.campDataModel параметры модели кампании
     * @param {String} ctx.campDataModel.id идентификатор кампании
     * @param {String} ctx.campDataModel.name название модели кампании
     */
    elem('metrika-counters').content()(function() {
        var campaign = this.ctx.campaign,
            metrikaCounters = u.escapeHTML(campaign.metrika_counters);

        return {
            block: 'b-metrika-counters-popup-adapter',
            metrikaCounters: metrikaCounters,
            isExperimentsOn: this.ctx.isExperimentsOn,
            OrderID: campaign.OrderID,
            dataModel: this.ctx.campDataModel,
            isPerformance: campaign.mediaType == 'performance',
            mixHintElem: {
                block: 'b-campaign-settings',
                elem: 'hint'
            }
        };
    })
);
