block('b-campaign-settings').elem('item').elemMod('of', 'metrics-counters').def()(function() {
    var data = this.data,
        campaign = data.campaign || {},
        isPerformance = campaign.mediaType === 'performance';

    return {
        mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
        left: {
            block: 'b-campaign-settings',
            elem: 'label',
            required: isPerformance,
            text: isPerformance ?
                [
                    iget2('b-campaign-settings', 'schyotchik-metriki', 'Счётчик Метрики'),
                    '&nbsp;',
                    {
                        block: 'b-mark-required'
                    }
                ] :
                iget2('b-campaign-settings', 'schyotchiki-metriki', 'Счётчики Метрики'),
            help: {
                width: 1100,
                url: isPerformance ?
                    u.getHelpUrl('smart-banners-additional-metrica-counter') :
                    u.getHelpUrl('additional-metrica-counter')
            }
        },
        right: this.mods.edit === 'yes' ?
            [
                {
                    block: 'b-campaign-settings',
                    elem: 'metrika-counters',
                    isExperimentsOn: !!data.is_ab_segments_enabled,
                    campaign: campaign,
                    campDataModel: this.modelParams
                },
                {
                    block: 'b-model-form-error',
                    mix: [{
                        block: 'b-model-form-error',
                        elem: 'control'
                    }],
                    modelParams: this.modelParams,
                    field: 'metrika_counters'
                }
            ] :
            campaign.metrika_counters ?
                iget2('b-campaign-settings', 'no-counter', '№ {counter}', {
                    counter: u.escapeHTML(campaign.metrika_counters)
                }) :
                iget2('b-campaign-settings', 'ne-zadany', 'Не заданы')
    };
});
