block('b-campaign-settings').elem('item').elemMod('of', 'metrics-key-goals')(
    def()(''),

    def().match(function() {
        var mediaType = this.data.campaign.mediaType;

        return u._.includes(['text', 'performance', 'internal_distrib', 'dynamic', 'mcbanner'], mediaType);
    })(function() {
        var data = this.data,
            isEditable = this.mods.edit === 'yes' || u.consts('rights').campaignSettingsWidgetsForSuperEnabled,
            campaign = data.campaign,
            availableGoals = data.available_meaningful_goals || {},
            meaningfulGoals = campaign.meaningful_goals || [],
            defaultGoalId = Object.keys(availableGoals).find(function(key) {
                return availableGoals[key].is_default_goal;
            }),
            currentGoals = meaningfulGoals.length ?
                meaningfulGoals :
                availableGoals[defaultGoalId] ?
                    [availableGoals[defaultGoalId]] :
                    [];

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'key-goals', 'Ключевые цели'),
                help: {
                    width: 1100,
                    url: u.getHelpUrl('meaningful-goals')
                }
            },
            right: [
                {
                    block: 'b-campaign-settings',
                    elem: 'key-goals-control',
                    elemMods: {
                        readonly: isEditable ? '' : 'yes'
                    },
                    content: {
                        block: 'b-metrics-key-goals',
                        mods: {
                            readonly: isEditable ? '' : 'yes'
                        },
                        isBeta: false,
                        goals: u.goals.transformGoalsFromServerFormat(availableGoals),
                        value: u.goals.transformValueFromServerFormat(currentGoals),
                        currency: campaign.currency,
                        hiddenControlName: 'json_meaningful_goals',
                        modelParams: this.modelParams,
                        strategyData: campaign.strategy2
                    }
                },
                {
                    block: 'b-model-form-error',
                    mix: [{
                        block: 'b-model-form-error',
                        elem: 'control'
                    }],
                    modelParams: this.modelParams,
                    field: 'meaningful_goals'
                }
            ]
        };
    })
);
