block('b-campaign-settings').elem('item').elemMod('of', 'minus-words')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: [
                iget2('b-campaign-settings', 'minus-frazy', 'Минус-фразы'),
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    stretched: true,
                    width: 1100,
                    url: u.getHelpUrl('negative-keywords-campaign')
                }
            ],
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'b-minus-words-control',
                        mix: {
                            block: 'b-metrika2',
                            js: {
                                items: [
                                    {
                                        event: 'popup-show',
                                        params: {
                                            EditCamp: {
                                                Negative_keywords: 'Popup'
                                            }
                                        }
                                    },
                                    {
                                        event: 'save-click',
                                        params: {
                                            EditCamp: {
                                                Negative_keywords: {
                                                    Popup: 'Save'
                                                }
                                            }
                                        }
                                    }
                                ],
                                blockName: 'b-minus-words-control'
                            }
                        },
                        modelParams: this.modelParams,
                        requestParams: {
                            for: 'campaign',
                            cid: campaign.cid,
                            ulogin: data.FORM.ulogin
                        },
                        showPreview: true,
                        for: 'campaign',
                        modal: true,
                        minusWordsHiddenName: 'json_campaign_minus_words',
                        minusWords: campaign.minus_words,
                        hintAboveControl: true,
                        hintMixes: [{ block: 'b-campaign-settings', elem: 'hint' }],
                        theme: 'normal'
                    },
                    {
                        block: 'b-minus-words-control',
                        elem: 'popup',
                        for: 'campaign',
                        modal: true,
                        limit: data.CONSTS.CAMPAIGN_MINUS_WORDS_LIMIT
                    }
                ] :
                {
                    block: 'b-campaign-settings',
                    elem: 'hint',
                    isEmpty: u.minusWords.isEmpty(campaign.minus_words),
                    text: campaign.minus_words,
                    isEditable: this.mods.edit === 'yes'
                }
        };
    })
);
