block('b-campaign-settings').elem('item').elemMod('of', 'notifications')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            useNotifications = (!campaign.ManagerUID || !!campaign.sendAccNews) && !!campaign.email,
            emailPreviewLength = 100,
            attrs = {};

        if (campaign.email && campaign.email.length > emailPreviewLength) {
            attrs['title'] = u.escapeHTML(campaign.email);
        }

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'pochtovye-uvedomleniya', 'Почтовые уведомления'),
                required: true
            },
            right: this.mods.edit === 'yes' ?
                {
                    block: 'b-campaign-email-notifications-adapter',
                    ulogin: data.FORM.ulogin,
                    notificationData: u['b-email-notification'].formData(campaign, data),
                    extended: true,
                    hintMixes: [{ block: 'b-campaign-settings', elem: 'hint' }]
                } :
                [
                    useNotifications ?
                        {
                            block: 'link',
                            mix: [{ block: 'hint-row' }],
                            url: 'mailto:' + campaign.email,
                            content: u.hellipCut(campaign.email, emailPreviewLength, u.escapeHTML),
                            attrs: attrs
                        } :
                        campaign.offlineStatNotice ? '' : iget2('b-campaign-settings', 'ne-nastroeny', 'Не настроены'),
                    useNotifications && !campaign.wallet_cid && {
                        block: 'hint-row',
                        content: iget2('b-campaign-settings', 'uvedomlyat-pri-s-ot', 'Уведомлять при {foo}% от последней оплаты', {
                            foo: u.escapeHTML(campaign.money_warning_value || 20)
                        })
                    },
                    useNotifications && !!campaign.sendWarn && campaign.mediaType != 'mcbanner' && {
                        block: 'hint-row',
                        content: iget2(
                            'b-campaign-settings',
                            'poluchat-preduprezhdeniya-o-smene2',
                            'Получать предупреждения об изменении объёма трафика, уточнении и отключении слов (через каждые {foo} минут)',
                            {
                                foo: u.escapeHTML(data.campaign.warnPlaceInterval)
                            }
                        )
                    },
                    !!data.campaign.offlineStatNotice && {
                        block: 'hint-row',
                        content: iget2('b-campaign-settings', 'poluchat-uvedomleniya-o-gotovnosti', 'Получать уведомления о готовности XLS-отчетов')
                    }
                ]
        };
    })
);
