block('b-campaign-settings').elem('item').elemMod('of', 'period')(

    def()(function() {
        var campaign = this.data.campaign,
            title = this.ctx.title || iget2('b-campaign-settings', 'daty-provedeniya-kampanii', 'Даты проведения кампании'),
            controlMods = this.ctx.controlMods || {};

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: title,
                help: u.getHelpUrl('campaign-dates'),
                required: true
            },
            right: [
                {
                    block: 'b-campaign-period',
                    mods: controlMods,
                    campaign: campaign,
                    isEditable: this.mods.edit === 'yes'
                }
            ]
        };
    }),

    def().match(function() {
        return this.mods.edit === 'yes';
    })(function() {
        var res = applyNext();

        res.right.push({
            block: 'b-model-form-error',
            mix: [{
                block: 'b-model-form-error',
                elem: 'control'
            }],
            modelParams: this.modelParams,
            field: 'start_date'
        });

        return res;
    })
);
