block('b-campaign-settings').elem('item').elemMod('of', 'rmp-goal')(

    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            rmpGoal = campaign.mobile_app_goal || data.FORM.mobile_app_goal || 'installs',
            namesMap = {
                clicks: iget2('b-campaign-settings', 'rmp-goal-clicks', 'Клики'),
                installs: iget2('b-campaign-settings', 'rmp-goal-installs', 'Установка приложения'),
                in_app_actions: iget2('b-campaign-settings', 'rmp-goal-actions', 'Действия в приложении')
            };

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'rmp-goal', 'Цель рекламной кампании'),
                help: u.getHelpUrl('mobile-apps-ads-goals')
            },
            right: this.mods.edit === 'yes' ?
                [
                    {
                        block: 'radio-button',
                        mix: {
                            block: this.block,
                            elem: 'rmp-goal'
                        },
                        name: 'mobile_app_goal',
                        mods: {
                            disabled: 'yes' // включается только тогда, когда это создание кампании и есть приложение
                        },
                        value: rmpGoal,
                        content: ['installs', 'clicks'/*, 'in_app_actions'*/].map(function(val) {
                            return {
                                elem: 'radio',
                                elemMods: { name: val },
                                controlAttrs: { value: val },
                                content: namesMap[val]
                            }
                        }, this)
                    }
                ] :
                [
                    namesMap[rmpGoal]
                ]
        };
    })
);
