block('b-campaign-settings').elem('item').elemMod('of', 'shows-frequency')(

    def()(function() {
        var campaign = this.data.campaign,
            frequencyValue = campaign.rf,
            frequencyPeriod = campaign.rfReset,
            frequencyControlParams = {},
            readOnlyText,
            isReadOnly = this.mods.edit !== 'yes';

        if (isReadOnly) {
            if (frequencyValue) {
                readOnlyText = frequencyPeriod === 0 ?
                    u.pluralForms(
                        iget2('b-campaign-settings', 'showsvalue-1000-pokaz-pokaza', '{showsValue} {показ|показа|показов} за период размещения', {
                            showsValue: frequencyValue,
                            context: 'showsValue - 1000'
                        }),
                        frequencyValue) :
                    u.pluralForms(
                        iget2(
                            'b-campaign-settings',
                            'showsvalue-1000-pokaz-pokaza-100',
                            '{showsValue} {показ|показа|показов} за {periodValue} {день|дня|дней}',
                            {
                                showsValue: frequencyValue,
                                periodValue: frequencyPeriod,
                                context: 'showsValue - 1000; periodValue - 10'
                            }
                        ),
                        frequencyValue,
                        frequencyPeriod
                    )
            } else {
                readOnlyText = iget2('b-campaign-settings', 'ne-zadano', 'Не задано');
            }
        } else {
            if (frequencyValue) {
                frequencyControlParams.showsValue = frequencyValue;
            }

            if (frequencyPeriod === 0) {
                frequencyControlParams.periodName = 'showsPeriod';
            } else if (frequencyPeriod) {
                frequencyControlParams.periodValue = frequencyPeriod;
            }
        }

        if (u.campaign.isInternal(campaign.mediaType)) {
            frequencyControlParams.disablePeriodSelect = true;
        }

        return {
            mixes: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: [
                {
                    block: 'checkbox',
                    mods: {
                        disabled: isReadOnly ? 'yes' : ''
                    },
                    mix: [
                        {
                            block: 'b-campaign-settings',
                            elem: 'shows-frequency-checkbox'
                        }
                    ],
                    content: [
                        {
                            elem: 'box',
                            content: [
                                {
                                    elem: 'control',
                                    attrs: {
                                        id: 'shows-frequency-checkbox',
                                        checked: !!frequencyValue
                                    }
                                },
                                { elem: 'tick' }
                            ]
                        },
                        {
                            elem: 'label',
                            content: [
                                iget2('b-campaign-settings', 'ogranichenie-chastoty-pokazov', 'Ограничение частоты показов'),
                                {
                                    block: 'b-help-link',
                                    mods: {
                                        type: 'modal'
                                    },
                                    stretched: true,
                                    url: u.getHelpUrl('frequency-capping')
                                }
                            ],
                            attrs: {
                                for: 'shows-frequency-checkbox'
                            }
                        }
                    ]
                }
            ],
            right: [
                isReadOnly ?
                    readOnlyText :
                    u._.extend({
                        block: 'b-shows-frequency-control',
                        mix: {
                            block: 'b-campaign-settings',
                            elem: 'shows-frequency-control',
                            elemMods: {
                                hidden: frequencyValue ? '' : 'yes'
                            }
                        }
                    }, frequencyControlParams),
                {
                    block: 'b-campaign-settings',
                    elem: 'hiddens',
                    fields: {
                        rf: frequencyValue,
                        // DIRECT-72400: Не сохраняется изменение Ограничения частоты показов при срабатывании валидации
                        // 0 - как число не записывается в input
                        rfReset: typeof frequencyPeriod === 'number' ?
                            frequencyPeriod.toString() :
                            frequencyPeriod
                    }
                }
            ]
        };
    })
);
