block('b-campaign-settings').elem('item').elemMod('of', 'sms-warnings')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            smsFlags = campaign.sms_flags,
            passportPhoneWarning = iget2(
                'b-campaign-settings',
                'novyy-nomer-budet-otobrazhyon',
                'Новый номер будет отображён после сохранения параметров кампании.'
            );

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'sms-uvedomleniya', 'SMS-уведомления'),
                help: {
                    url: u.getHelpUrl('sms-alerts'),
                    width: 1100
                }
            },
            right: [
                {
                    block: 'b-campaign-settings',
                    elem: 'sms-hint',
                    isEditable: this.mods.edit === 'yes',
                    phone: campaign.sms_phone,
                    flags: smsFlags,
                    time: campaign.sms_time
                },
                // if (this.mods.edit === 'yes' && !(hasLoginRights('is_developer') && hasLoginRights('superreader_control'))) {
                this.mods.edit === 'yes' && {
                    block: 'b-outboard-controls',
                    mods: { modal: 'yes' },
                    mix: [{ block: 'b-campaign-settings', elem: 'sms-control' }],
                    params: {
                        cid: campaign.cid,
                        ulogin: u.escapeHTML(data.FORM.ulogin)
                    },
                    content: [
                        {
                            elem: 'switcher',
                            js: true,
                            theme: 'normal',
                            switcherText: campaign.sms_phone ? iget2('b-campaign-settings', 'izmenit', 'Изменить') : iget2('b-campaign-settings', 'dobavit', 'Добавить')
                        },
                        {
                            elem: 'popup',
                            header: iget2('b-campaign-settings', 'nastroyka-polucheniya-sms-uvedomleniy', 'Настройка получения SMS-уведомлений'),
                            innerBlock: applyCtx({
                                block: 'b-sms-notification',
                                options: campaign,
                                passportPhoneWarning: passportPhoneWarning
                            })
                        },
                        {
                            block: 'b-campaign-settings',
                            elem: 'hiddens',
                            fields: {
                                active_orders_money_out_sms: smsFlags.active_orders_money_out_sms,
                                camp_finished_sms: smsFlags.camp_finished_sms,
                                moderate_result_sms: smsFlags.moderate_result_sms,
                                notify_metrica_control_sms: smsFlags.notify_metrica_control_sms,
                                notify_order_money_in_sms: smsFlags.notify_order_money_in_sms,
                                sms_time_hour_from: campaign.sms_time_hour_from,
                                sms_time_min_from: campaign.sms_time_min_from,
                                sms_time_hour_to: campaign.sms_time_hour_to,
                                sms_time_min_to: campaign.sms_time_min_to,
                                paused_by_day_budget_sms: smsFlags.paused_by_day_budget_sms
                            }
                        }
                    ]
                },
                this.mods.edit === 'yes' && {
                    block: 'b-campaign-settings',
                    elem: 'passport-phone-warning',
                    content: passportPhoneWarning
                }
            ]
        };
    })
);
