block('b-campaign-settings').elem('item').elemMod('of', 'strategy').def()(function() {
    var data = this.data,
        campaign = data.campaign,
        wallet = data.wallet || {},
        walletDayBudgetSettings = wallet.day_budget || {},
        strategyBemJson = {
            block: 'b-campaign-strategy2',
            mods: { 'campaign-type': u.beminize(campaign.mediaType) },
            campaignType: campaign.mediaType,
            campDataModel: this.modelParams,
            isNetStrategyEnabled: campaign.mediaType !== 'dynamic' ||
                u.consts('rights').manageContextForDynamicCampaigns,
            dayBudgetSettings: {
                isEnabled: true,
                currency: campaign.currency,
                maxDailyChangeCount: data.MAX_DAY_BUDGET_DAILY_CHANGE_COUNT,
                showOptionsHint: true
            },
            walletInfo: {
                dayBudgetSettings: {
                    sum: walletDayBudgetSettings.sum,
                    showMode: walletDayBudgetSettings.show_mode
                },
                url: u.getWalletLink(campaign.AgencyID)
            },
            hintMixes: [{ block: 'b-campaign-settings', elem: 'hint' }],
            isNewCamp: this.data.new_camp,
            isMobileAppNotPreselected: (this.data.app_list || []).length !== 1,
            isChangeManualStrategyName: Boolean(this.data.has_change_name_bid_optimization),
            isSavedPeriodStrategyEditable: u.consts('isEditAvgCpmPeriodStrategyWithoutRestartEnabled')
        },
        isCPM = u.campaign.isCpm(campaign.mediaType),
        isMCBanner = campaign.mediaType === 'mcbanner',
        isContentPromotion = campaign.mediaType === 'content_promotion',
        helpLinkId = 'selecting-strategy';

    if (isCPM) {
        helpLinkId = 'selecting-strategy-cpm-campaign';
    } else if (isContentPromotion || isMCBanner) {
        helpLinkId = 'selecting-strategy-search';
    }

    if (this.mods.edit === 'yes' || u.consts('rights').campaignSettingsWidgetsForSuperEnabled) {
        strategyBemJson.mods['with-hidden-input'] = 'yes';
        strategyBemJson.mix = {
            block: 'b-metrika2',
            js: {
                items: [
                    {
                        event: 'popup-show',
                        params: {
                            EditCamp: {
                                Strategy: 'Popup'
                            }
                        }
                    },
                    {
                        event: 'save-click',
                        params: {
                            EditCamp: {
                                Strategy: {
                                    Popup: 'Save'
                                }
                            }
                        }
                    }
                ],
                blockName: 'b-campaign-strategy2'
            }
        };
        strategyBemJson.hintAboveControl = true;
        strategyBemJson.theme = 'normal';
    } else {
        strategyBemJson.mods['view-only'] = 'yes';
    }

    if (u['attribution-model'].isNewPolicyEnabled(campaign.mediaType)) {
        strategyBemJson = [].concat(
            strategyBemJson,
            {
                block: 'b-campaign-settings',
                elem: 'hidden-glue',
                name: 'attribution_model',
                value: campaign.attribution_model
            }
        );
    }

    return {
        mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
        left: {
            block: 'b-campaign-settings',
            elem: 'label',
            required: true,
            text: [
                iget2('b-campaign-settings', 'strategiya', 'Стратегия'),
                campaign.mediaType === 'mobile_content' && [
                    '&nbsp;',
                    {
                        block: 'b-mark-required'
                    }
                ]
            ],
            help: u.getHelpUrl(helpLinkId)
        },
        right: strategyBemJson
    };
});
