block('b-campaign-settings').elem('item').elemMod('of', 'timetargeting')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            isEditable = this.mods.edit === 'yes' || u.consts('rights').campaignSettingsWidgetsForSuperEnabled;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: iget2('b-campaign-settings', 'vremennoy-targeting', 'Временной таргетинг'),
                help: u.getHelpUrl('timetargeting')
            },
            right: applyCtx({
                block: 'b-time-targeting-presenter',
                mix: isEditable ?
                    {
                        block: 'b-metrika2',
                        js: {
                            items: [
                                {
                                    event: 'popup-show',
                                    params: {
                                        EditCamp: {
                                            Time_targeting: 'Popup'
                                        }
                                    }
                                },
                                {
                                    event: 'save-click',
                                    params: {
                                        EditCamp: {
                                            Time_targeting: {
                                                Popup: 'Save'
                                            }
                                        }
                                    }
                                }
                            ],
                            blockName: 'b-time-targeting-presenter'
                        }
                    } :
                    {},
                js: isEditable ? { campModelParams: this.modelParams } : false,
                params: {
                    isEditable: isEditable,
                    data: {
                        campaign: {
                            mediaType: campaign.mediaType,
                            timetargeting: campaign.timetargeting,
                            strategy: campaign.strategy
                        },
                        timezone_groups: data.timezone_groups,
                        is_turkish_client: data.is_turkish_client
                    }
                },
                theme: 'normal',
                hintAboveControl: true,
                hintMixes: [{ block: 'b-campaign-settings', elem: 'hint' }]
            })
        };
    })
);
