block('b-campaign-settings').elem('item').elemMod('of', 'vcard')(
    def()(function() {
        var data = this.data,
            campaign = data.campaign,
            isEditable = this.mods.edit === 'yes' || u.consts('rights').campaignSettingsWidgetsForSuperEnabled;

        return {
            mixesRow: [{ block: this.block, elem: this.elem, elemMods: this.elemMods }],
            left: {
                block: 'b-campaign-settings',
                elem: 'label',
                text: isEditable ? iget2('b-campaign-settings', 'ispolzovat-edinyy-adres-i', 'Использовать единый адрес и телефон') : iget2('b-campaign-settings', 'adres-i-telefon', 'Адрес и телефон'),
                help: u.getHelpUrl('specify-link')
            },
            right: isEditable ?
                {
                    block: 'b-vcard-control',
                    mods: { type: 'campaign' },
                    mixes: [
                        {
                            block: 'b-campaign-settings',
                            elem: 'vcard'
                        },
                        {
                            block: 'b-metrika2',
                            js: {
                                event: 'change',
                                target: 'EditCamp.Address_and_telephone.Enabled',
                                blockName: 'b-vcard-control'
                            }
                        }
                    ],
                    vcardHint: '&nbsp;',
                    is_vcard_open: campaign.camp_with_common_ci,
                    vcard: (campaign && campaign.vcard) || {}
                } :
                applyCtx({
                    block: 'b-vcard-view',
                    mix: [{ block: 'b-campaign-settings', elem: 'vcard-view' }],
                    vcard: data.campaign.vcard
                })
        };
    })
);
