block('b-campaign-settings').elem('server-error')(
    def().match(function() {
        return this.data.campaign.error ||
            this.data.campaign.banners_status && this.data.campaign.banners_status.running_unmoderated >= 1;
    })(function() {
        var data = this.data,
            campaign = data.campaign || {},
            isRunningUnModerated = campaign.banners_status && campaign.banners_status.running_unmoderated >= 1;

        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'server-error' }],
            left: [
                isRunningUnModerated && {
                    block: 'b-campaign-settings',
                    elem: 'error-text',
                    content: [
                        {
                            block: 'icon',
                            mods: { 'size-12': 'alert' },
                            mix: [{ block: 'b-campaign-settings', elem: 'error-icon' }]
                        },
                        iget2(
                            'b-campaign-settings',
                            'v-etoy-kampanii-est',
                            'В этой кампании есть отклонённые объявления или объявления, ожидающие модерацию.<br>Для них изменения параметров вступят в силу только после принятия модератором!'
                        )
                    ]
                },
                campaign.error && {
                    block: 'b-campaign-settings',
                    elem: 'error-text',
                    content: [
                        {
                            block: 'icon',
                            mods: { 'size-12': 'alert' },
                            mix: [{ block: 'b-campaign-settings', elem: 'error-icon' }]
                        },
                        u.escapeHTML(campaign.error).replace(/\n/g, '<br/>')
                    ]
                }
            ]
        };
    })
);
