block('b-campaign-settings').mod('edit', 'yes')(

    addMix()([{
        block: 'b-metrika2',
        js: {
            items: [
                {
                    event: 'advanced-setting-show',
                    params: {
                        EditCamp: 'Show_advanced_settings'
                    }
                },
                {
                    event: 'save-click',
                    params: {
                        EditCamp: 'Save'
                    }
                }
            ],
            blockName: 'b-campaign-settings'
        }
    }]),

    js()(function() {
        return {
            campaign: this.data.campaign,
            all_retargeting_conditions: this.data.all_retargeting_conditions
        }
    }),

    content()(function() {
        var data = this.data,
            mediaType = (data.campaign || {}).mediaType,
            isDirectClient = !!(data.login_rights != null &&
                !data.login_rights.is_client_supported_by_freelancer &&
                !data.login_rights.client_have_agency &&
                !data.login_rights.client_is_serviced
            ),
            isNewCamp = data.campaign.statusEmpty == 'Yes' || data.new_camp || data.continue_creating;

        return [
            {
                elem: 'form',
                action: data.script,
                content: {
                    block: 'b-layout-form2',
                    header: applyCtx({ block: 'b-campaign-settings-header', isEditable: true }),
                    hiddenInputs: apply('hiddenInputs'),
                    submit: {
                        position: 'left',
                        control: {
                            block: 'button',
                            mods: { disabled: 'yes', theme: 'action', size: 'm' },
                            mix: [
                                { block: 'b-campaign-settings', elem: 'submit' },
                                isNewCamp && {
                                    block: 'b-metrika2',
                                    js: {
                                        counter: 191494,
                                        event: 'click',
                                        target: 'CREATE_CAMPAIGN_CLICKED_NEXT',
                                        targetParams: {
                                            mediaType: mediaType
                                        },
                                        blockName: 'button'
                                    }
                                }
                            ],
                            content: data.exported ?
                                iget2('b-campaign-settings', 'perenesti', 'Перенести') :
                                isNewCamp ?
                                    iget2('b-campaign-settings', 'dalshe', 'Дальше') :
                                    iget2('b-campaign-settings', 'sohranit', 'Сохранить')
                        }
                    },
                    groups: apply('groupsOfSettings')
                }
            },

            // если это новая кампания
            // и клиент из России || Беларусии || Казахстана || Узбекистана
            // и он явялется прямым клиентом (без менеджера, без агенства, без фрилансера)
            // то отображаем баннер
            data.new_camp &&
            data.is_first_camp && (
                data.client_country === '225' ||  // Россия
                data.client_country === '149' ||  // Беларусь
                data.client_country === '159' ||  // Казахстан
                data.client_country === '171'     // Узбекистан
            ) &&
            isDirectClient && {
                elem: 'banner',
                content: {
                    block: 'b-agency-banner',
                    suggestYandexService: !!data.suggest_yandex_service,
                    suggestExternalService: !!data.suggest_non_yandex_service,
                }
            }
        ];
    }),

    /**
     * Набор скрытых инпутов
     * @returns {Array}
     */
    mode('hiddenInputs')(function() {
        var data = this.data,
            form = data.FORM,
            campaign = data.campaign || {};

        return [
            {
                name: 'from',
                value: data.first_camp_settings_request_type
            },
            data.currentAgency && {
                name: 'for_agency',
                value: data.currentAgency.login,
                mix: {
                    elem: 'for-agency'
                }
            },
            {
                name: 'fio',
                value: campaign.fio
            },
            {
                name: 'cmd',
                mix: { block: 'b-campaign-settings', elem: 'cmd' },
                value: data.new_camp == 1 ? 'saveNewCamp' : 'saveCamp'
            },
            {
                name: 'retpath',
                value: form.retpath
            },
            form.ulogin && {
                name: 'ulogin',
                value: u.escapeHTML(form.ulogin)
            },
            {
                name: 'cid',
                value: u.escapeHTML(campaign.cid || '')
            },
            form.interface_type && {
                name: 'interface_type',
                value: u.escapeHTML(form.interface_type)
            },
            form.currency && {
                name: 'currency',
                value: u.escapeHTML(form.currency)
            },
            form.client_country && {
                name: 'client_country',
                value: u.escapeHTML(form.client_country)
            },
            form.is_media && {
                name: 'is_media',
                value: u.escapeHTML(form.is_media)
            },
            {
                name: 'mediaType',
                value: campaign.mediaType || 'text'
            },
            form.popupMode && {
                name: 'popupMode',
                value: '1'
            },
            data.continue_creating && {
                name: 'continue_creating',
                value: '1'
            },
            form.is_alone_trafaret_allowed && {
                name: 'is_alone_trafaret_allowed',
                value: '1'
            },
            form.from_new_interface == '1' && {
                name: 'from_new_interface',
                value: '1'
            },
            form.require_filtration_by_dont_show_domains == 1 && {
                name: 'require_filtration_by_dont_show_domains',
                value: '1'
            }
        ];
    })
);
