/**
 *
 * @event b-campaign-settings#advanced-setting-show показать расширенные настройки
 * @event b-campaign-settings#save-click клик по кнопке "Сохранить"
 *
 * @fires b-campaign-settings#advanced-setting-show
 * @fires b-campaign-settings#save-click
 */
BEM.DOM.decl({ block: 'b-campaign-settings', modName: 'edit', modVal: 'yes', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');

            this.__base();

            var strategyModel = this.model.get('strategy2'),
                metrika = BEM.blocks['b-metrika2'],
                mediaType = this.model.get('mediaType');

            this._hasDontShowInternalSites = {
                common: false,
                video: false
            };

            this._updateContextLimitTextDebounce = $.debounce(this._updateContextLimitText, 10);

            if ((this.model.get('DontShow') || []).length) {
                this._checkHasDontShowInternalSites('common', 'DontShow');
            }
            if ((this.model.get('disabled_video_placements') || []).length) {
                this._checkHasDontShowInternalSites('video', 'disabled_video_placements');
            }

            this._subMan.wrap(this.model)
                .on('DontShow disabled_ssp require_filtration_by_dont_show_domains', 'change', this._updateDisabledPlatforms, this)
                .on('product_type', 'change', this._onProductTypeChange, this)
                .on('DontShow', 'change', this._checkHasDontShowInternalSites.bind(this, 'common', 'DontShow'));

            if (
                u.campaign.isCpm(mediaType) &&
                u.consts('rights').allowedCpmVideoBanners &&
                mediaType !== 'cpm_yndx_frontpage'
            ) {
                this._subMan.wrap(this.model)
                    .on('disabled_video_placements', 'change', this._updateDisabledCpmVideo, this)
                    .on('disabled_video_placements', 'change', this._checkHasDontShowInternalSites.bind(this, 'video', 'disabled_video_placements'));
            }

            if (!u.campaign.isCpm(mediaType) && !u.campaign.isInternal(mediaType)) {
                this._subMan.on(
                    this.model,
                    'ContextLimit ContextPriceCoef enable_cpc_hold',
                    'change',
                    this._updateContextLimitTextDebounce,
                    this
                );
            }

            this._setMetrikaDisabledStatus(this.model.get('isCpaPayForConversionEnabled'));

            // для ТГО, ДТО, баннеров в сетях (DIRECT-52624), для ГО на поиске (DIRECT-69639)
            if ([
                'text',
                'dynamic',
                'cpm_banner',
                'cpm_deals',
                'mcbanner',
                'cpm_yndx_frontpage'
            ].indexOf(mediaType) > -1) {
                this.model.hasField('status_click_track') &&
                    this._subMan.wrap(this.model)
                        .on('status_click_track', 'change', function() {
                            var popup = this._getSharedPopup();

                            if (this.model.get('status_click_track')) {
                                popup.hide();
                            } else {
                                popup
                                    .setContent(BEMHTML.apply({
                                        block: 'b-campaign-settings',
                                        elem: 'status-click-track-notice'
                                    }))
                                    .show(this.elem('status-click-track-checkbox'));
                            }
                        }, this);

                this.model.hasField('statusOpenStat') &&
                    this._subMan.wrap(this.model)
                        .on('statusOpenStat', 'change', function() {
                            var popup = this._getSharedPopup();

                            if (!this.model.get('statusOpenStat')) {
                                popup.hide();
                            } else {
                                popup
                                    .setContent(BEMHTML.apply({
                                        block: 'b-message',
                                        mix: { block: 'b-campaign-settings', elem: 'popup-message' },
                                        content: iget2(
                                            'b-campaign-settings',
                                            'pozhaluysta-ubedites-v-tom',
                                            'Пожалуйста, убедитесь в том, что параметр _openstat=... в URL не конфликтует с вашим сайтом, и сервер корректно отображает соответствующие страницы.'
                                        )
                                    }))
                                    .show(this.elem('status-open-stat-checkbox'));
                            }
                        }, this);
            }

            this._subMan.wrap(strategyModel)
                .on('options is_net_stopped', 'change', this._onStrategyChange, this)
                .on('is_net_stopped', 'change', this._setDontShowInternalSitesWarningVisibility.bind(this, 'common'))
                .on('is_net_stopped', 'change', this._setDontShowInternalSitesWarningVisibility.bind(this, 'video'));

            this._initExpander();

            this.model.hasField('device_targeting') &&
                this._subMan.wrap(this.model).on('device_targeting', 'change', this._updateDeviceTargetingText, this);

            u.graspSelf.call(this, {
                _submitButton: 'button on submit',
                _vcard: '? b-vcard-control inside',
                _smsControl: '? b-outboard-controls on sms-control',
                _agencySelect: '? b-agency-select inside',
                _dontShow: '? b-outboard-controls inside dont-show',
                _disabledIps: '? b-outboard-controls inside disabled-ips',
                _strategy: '? b-campaign-strategy2 inside',
                _frequency: '? b-shows-frequency-control inside',
                _adjustment: '? b-adjustment-rates-popup inside',
                _region: '? b-campaign-region inside',
                _agencyButton: '? button inside order-agency-button',
                _mobileAppSelect: '? b-campaign-mobile-app-control inside',
                _frontpageTypesSelect: '? select2 on frontpage-types-select',
                _frontpageTypesMenu: '? menu on frontpage-types-menu',
                _restrictionTypeRadio: '? radio-button on internal-restriction-type-radio',
                _restrictionInput: '? input on internal-restriction-value-input',
                _aloneTrafaretCheckbox: '? checkbox on alone-trafaret-checkbox',
                _aloneTrafaretHidden: '? b-hidden on hidden-alone-trafaret',
                _aloneTrafaretTooltip: '? tooltip on alone-trafaret-tooltip'
            });

            this._agency = this.findBlockInside({ block: 'b-hidden', elem: 'for-agency' });

            if (this._smsControl) {
                this._subMan.wrap(this._smsControl)
                    .on('accept', this._onSmsControlSave, this);
                this._subMan.wrap(this._smsControl.getInnerBlock())
                    .on('show', this._onSmsControlShow, this)
                    .on('click-passport-phone', this._showPassportPhoneWarning, this);
            }

            this._agencySelect && this._subMan.wrap(this._agencySelect)
                .on('agency-change', this._onAgencyChange, this);

            this._subMan.on(this._submitButton, 'click', function(e) {
                e.preventDefault();
                this._onSubmitClick();
            }, this);

            this._dontShow && this._subMan.on(this._dontShow, 'show', function() {
                this.getInnerBlock().findBlockInside('input', 'input').elem('control').focus();
            }, this._dontShow);

            this._disabledIps && this._subMan.on(this._disabledIps, 'show', function() {
                this.getInnerBlock().findBlockInside('input', 'input').elem('control').focus();
            }, this._disabledIps);

            this._frontpageTypesSelect && this._subMan.on(this._frontpageTypesSelect, 'change', function(e, data) {
                // дизейблим оставшийся вариант выбора
                // должен быть выбрать минимум 1
                if (data.currVal.length === 1) {
                    this._frontpageTypesMenu.getItems().forEach(function(item) {
                        if (this._frontpageTypesMenu.elemParams(item).val === data.currVal[0]) {
                            this._frontpageTypesMenu.setMod(item, 'disabled', 'yes');
                        }
                    }.bind(this));
                } else if (data.currVal.length > 1) {
                    this._frontpageTypesMenu.getItems().forEach(function(item) {
                        this._frontpageTypesMenu.delMod(item, 'disabled');
                    }.bind(this));
                }

                this.model.set('allowed_frontpage_types', JSON.stringify(this._frontpageTypesSelect.getVal()));
            }, this);

            if (this._agencyButton) {
                metrika.reachGoal('SHOW_AGENCY_BANNER_STEP1');
            }

            this._initAloneTrafaretCheckbox();

            this._enableUnloadChecker();

            // u._.compact - если блоков не нашлось :)
            var innerBlocks = u._.compact([this.findBlockInside('b-campaign-strategy2')]),
                initedCache = [];

            innerBlocks.forEach(function(block, i) {
                initedCache.push($.Deferred());
                block.getMod('js') == 'inited' && initedCache[i].done();
                block.on('init', function() {
                    initedCache[i].done();
                }, this);
            }, this);
            //DIRECT-33972
            $.when(initedCache).done(function() {
                this._submitButton.delMod('disabled');
            }.bind(this));

            this.model.fix();

            this.bindTo('expand-on', 'click', function() {
                this.trigger('advanced-setting-show');
            });
            this.bindTo('submit', 'click', function() {
                this.trigger('save-click');
            });

            metrika.params({ params: 'EditCamp' });

            this._initShowsFrequencyControl();
            this._initEShowsControls();

            // обновление в модели кампании параметров по корректировкам ставок
            // нужны для для построения превью прогноза и прогноза в попапе настроек стратегии
            // используется для автостратегий в медийных кампаниях
            if (u.campaign.isCpm(mediaType) && this._adjustment) {
                this._subMan.wrap(this._adjustment)
                    .on('save', function() {
                        this.model.update({
                            multipliersPct: u['i-adjustment-rates-data'].getMultipliersPct(this.model.getMultipliersData())
                        });
                    }, this);
            }

            this._initKeyGoalsControl();
            this._initExperimentsControl();

            this._mobileAppSelect && this._initMobileAppSelectControl();
            this._restrictionTypeRadio && this._initRestrictionTypeControl();
            this.blockInside('rmp-goal', 'radio-button') && this._initRmpGoalControl();

            this._initialSettings = this.model.toJSON();

            this._reachMetrikaGoalsOnInit(mediaType);
        },

        expanded: {
            no: function() {
                // При скрытии "расширенных настроек" необходимо скрывать открытые в них попапы.
                // Т.к. все попапы лежат в body - плохо проходится по ним и закрывать каждый по отдельности.
                // Используем штатное средство в виде каналов.
                BEM.channel('direct-popups').trigger('hide');
            }

        }
    },

    /**
     * Проверяет изменилась ли страница
     * @returns {boolean} true если были изменения
     */
    hasChanges: function() {
        return this.model.isChanged() ||
            this._getTimeTargetingPresenter() && this._getTimeTargetingPresenter().isChanged();
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this._disableUnloadChecker();
        this._deinitAloneTrafaretCheckbox();

        this.__base.apply(this);
    },

    /**
     * Обработчик отправки формы
     * @private
     */
    _onSubmitClick: function() {
        var _this = this,
            mediaType = this.model.get('mediaType');
        this._submitButton.setMod('disabled', 'yes');

        // инитим т.к. json_hierarchical_multipliers должны быть заполнены
        this.findBlockInside('b-adjustment-rates-popup');

        this
            ._chain(
                this._checkFinishDate,
                this._showsFrequencyControl && this._checkShowsFrequencyControl,
                this._validateModel,
                this._validateStrategy,
                mediaType === 'mobile_content' && this._validateRmpStrategy,
                u.campaign.isCpm(mediaType) && this._validateCpmStrategy,
                this._vcard && this._checkVcard,
                this._checkClickTracking)
            .then(function() {
                _this._reachMetrikaGoals(_this._initialSettings, _this.model.toJSON(), mediaType);
                _this._disableUnloadChecker();
                _this._prepareAloneTrafaretInput();
                _this.elem('form').submit();
            })
            .fail(function() {
                _this._submitButton.delMod('disabled');
            });
    },

    _reachMetrikaGoals: function(initData, newData, mediaType) {
        var initDayBudget = initData.day_budget2 || {},
            newDayBudget = newData.day_budget2 || {},
            newStrategy = newData.strategy2,
            counter = BEM.blocks['b-metrika2'];

        if (initDayBudget.set && !newDayBudget.set) {
            counter.reachGoal('COMPANY_DAILY_LIMIT_OFF', {
                COMPANY_DAILY_LIMIT_OFF: {
                    beforeLimit: initDayBudget.sum
                }
            });
            counter.reachGoal('DAILY_BUDGET_LIMIT_CAMPAIGN_OFF');
        } else if (initDayBudget.set && newDayBudget.set && initDayBudget.sum < newDayBudget.sum) {
            counter.reachGoal('COMPANY_DAILY_LIMIT_UP', {
                COMPANY_DAILY_LIMIT_UP: {
                    difference: newDayBudget.sum - initDayBudget.sum
                }
            });
            counter.reachGoal('DAILY_BUDGET_LIMIT_CAMPAIGN_INCREASE');
        } else if (initDayBudget.set && newDayBudget.set && initDayBudget.sum > newDayBudget.sum) {
            counter.reachGoal('DAILY_BUDGET_LIMIT_CAMPAIGN_DECREASE');
        }

        if (['text', 'dynamic', 'performance'].includes(mediaType) && this.params.newCamp) {
            var strategyData = newStrategy.is_search_stopped && newStrategy.options.net ?
                newStrategy.options.net :
                newStrategy.options;

            switch (strategyData.name) {
                case u.strategy.AUTOBUDGET_ROI:
                    counter.reachGoal(mediaType + '-campaign-saved-with-roi-strategy');
                    break;

                case u.strategy.AUTOBUDGET_AVG_CLICK:
                    counter.reachGoal(mediaType + '-campaign-saved-with-optimize-clicks-strategy', {
                        type: 'autobudget_avg_click'
                    });
                    break;

                case u.strategy.AUTOBUDGET_WEEK_BUNDLE:
                    counter.reachGoal(mediaType + '-campaign-saved-with-optimize-clicks-strategy', {
                        type: 'autobudget_week_bundle'
                    });
                    break;

                case u.strategy.AUTOBUDGET_AVG_CPA:
                    if (strategyData.goal_id !== undefined) {
                        counter.reachGoal(mediaType + '-campaign-saved-with-optimize-conversions-strategy');
                    }
                    break;

                case u.strategy.AUTOBUDGET:
                    if (strategyData.goal_id !== undefined) {
                        counter.reachGoal(mediaType + '-campaign-saved-with-optimize-conversions-strategy');
                    } else {
                        counter.reachGoal(mediaType + '-campaign-saved-with-optimize-clicks-strategy', {
                            type: 'autobudget'
                        });
                    }
                    break;

                case u.strategy.MAXIMUM_COVERAGE:
                case u.strategy.DIFFERENT_PLACES:
                case u.strategy.DEFAULT:
                    counter.reachGoal(mediaType + '-campaign-saved-with-manual-strategy');
                    break;

                default:
                    counter.reachGoal(mediaType + '-campaign-saved-with-manual-strategy');
                    break;
            }
        }
    },

    _initExpander: function() {
        //Открыть, скрыть контролы
        this.elem('expander').on('click', function(e) {
            this.toggleMod('expanded', 'yes', 'no');
            e.stopPropagation();
        }.bind(this));

        this.setMod('expanded', 'no');
    },

    /**
     * Показывает в строке «SMS-уведомления» предупреждение
     * «Новый номер будет отображён после сохранения параметров кампании.»
     * DIRECT-51348
     * @private
     */
    _showPassportPhoneWarning: function() {
        return this.setMod(this.elem('passport-phone-warning'), 'show', 'yes');
    },

    _updateContextLimitTextDebounce: function() {
        //определяется в init
    },

    /**
     * Событие изменения агентства в селекте кампании
     * @param {Event} e событие
     * @param {String} agency агентство (логин)
     * @private
     */
    _onAgencyChange: function(e, agency) {
        this._agency && this._agency.val(agency);
    },

    /**
     * Включает проверку модели при уходе со страницы
     * @private
     */
    _enableUnloadChecker: function() {
        // Обработчик ухода со страницы
        BEM.blocks['i-unload-warning'].addChecker(this.hasChanges, this);
    },

    /**
     * Выключает проверку модели при уходе со страницы
     * @private
     */
    _disableUnloadChecker: function() {
        BEM.blocks['i-unload-warning'].removeChecker(this.hasChanges, this);
    },

    /**
     * Обновляет строку с текущим состоянием настроек на тематических площадках
     * @private
     */
    _updateContextLimitText: function() {
        var model = this.model,
            strategy = model.get('strategy2').toJSON(),
            areStrategyDependableShows = u.contextLimit.areStrategyDependableShows(strategy.name, strategy.options);

        BEM.DOM.update(
            this.elem('context-limit-text-wrap'),
            BEMHTML.apply({
                block: 'b-campaign-settings',
                elem: 'context-limit-text',
                elemMods: {
                    bold: strategy.is_net_stopped ? 'yes' : 'no'
                },
                mix: [
                    { block: 'b-outboard-controls', elem: 'data-hint', mods: { type: 'tail' } },
                    { block: 'b-campaign-settings', elem: 'hint' }
                ],
                isDiffPlaces: strategy.name == 'different_places',
                ContextLimit: model.get('ContextLimit'),
                ContextPriceCoef: model.get('ContextPriceCoef'),
                enable_cpc_hold: model.get('enable_cpc_hold'),
                isNetStopped: strategy.is_net_stopped,
                areStrategyDependableShows: areStrategyDependableShows
            })
        );

        this.setMod(
            this.elem('context-limit'),
            'enabled',
            this._isContextSettingsTurnedOff() || areStrategyDependableShows ? 'no' : 'yes'
        );
    },

    /**
     * Обработчик изменения настроек таргетинга на устройства
     * @param {Object} event событие изменения
     * @param {Object} data данные
     * @param {String} data.value значение настроек таргетинга
     * @private
     */
    _updateDeviceTargetingText: function(event, data) {
        BEM.DOM.update(
            this.elem('device-targeting-text-wrap'),
            BEMHTML.apply({
                block: 'b-campaign-settings',
                elem: 'device-targeting-text',
                targeting: data.value
            })
        );
    },

    /**
     * Обработчик включения показов на тематических площадках
     * Может быть сделано кнопкой в интерфейсе или неявно через стратегии
     * @private
     */
    _enableContextLimit: function(event) {
        this.model.get('strategy2')
            .set('is_net_stopped', false)
            .fix();

        // включаем contextlimit через попап стратегий - алерт показывать не нужно
        this.model
            .update(u.contextLimit.getDefaultValues())
            .fix();
    },

    /**
     * Обработчик сохранения стратегии "только на поиске" - отключение показов в сетях
     * @private
     */
    _disableContextLimit: function() {
        this.model.get('strategy2')
            .set('is_net_stopped', true)
            .fix();
    },

    /**
     * Обработчик сохранения настроек СМС-уведомлений
     * @param {Object} e событие
     * @param {Object} data настройки
     * @private
     */
    _onSmsControlSave: function(e, data) {
        this.model.update(u._.pick(data, Object.keys(this.model.fieldsDecl))).fix();
    },

    /**
     * Обработчик открытия попапа с настройками смс
     * @param {Event} e событие
     * @param {Object} e.target блок смс
     * @private
     */
    _onSmsControlShow: function(e) {
        var smsNotifyBlock = e.target;

        // ставим флаг notify_metrica_control_sms, так как он может изменяться
        // в разделе "мониторинг сайта"
        smsNotifyBlock.model
            .set('notify_metrica_control_sms', this.model.get('notify_metrica_control_sms'))
            .set('notify_metrica_control_sms_disabled', +this.model.get('statusMetricaControl'));

        smsNotifyBlock.toggleFinishDateSms(!!this.model.get('finish_date') && !!this.model.get('sms_phone'));
    },

    /**
     * Обработчик изменения поля стратегия модели кампании
     * @param {Object} e
     * @param {Object} data
     * @private
     */
    _onStrategyChange: function(e, data) {
        this._updateContextLimitByStrategy(data.field, data.value);
        this._setMetrikaDisabledStatusByStrategy(data.field, data.value);
    },

    _setMetrikaDisabledStatusByStrategy: function(field, value) {
        if (field == 'options') {
            var isCpaPayForConversionEnabled = value.pay_for_conversion || (value.net && value.net.pay_for_conversion),
                mediaType = this.model.get('mediaType');

            if (mediaType === 'text') {
                this._setMetrikaDisabledStatus(isCpaPayForConversionEnabled)
            }
        }
    },

    _setMetrikaDisabledStatus: function(isCpaPayForConversionEnabled) {
        var metrikaCheckbox = this.findBlockOn('status-click-track-checkbox', 'checkbox');

        if (metrikaCheckbox) {
            if (isCpaPayForConversionEnabled) {
                this.model.set('status_click_track', true);
                metrikaCheckbox.setMod('disabled', 'yes');
            } else {
                metrikaCheckbox.setMod('disabled', '')
            }
        }
    },

    /**
     * Обновляет значения в блоке "Настройки на тематических площадках" в зависимости от установленной стратегии
     * @param {Boolean} strategyField - название изменившегося поля
     * @param {Object|Boolean} strategyValue - значение (опции либо отключены показы в сетях)
     * @returns {BEM}
     * @private
     */
    _updateContextLimitByStrategy: function(strategyField, strategyValue) {
        var areStrategyDependableShows,
            strategy = this.model.get('strategy2').toJSON();
        /**
         * проверяем является ли стратегия той при которой показываем принимаем в расчет параметр enable_cpc_hold
         * либо стратегия независимого управления для разных площадок
         * для независимого управления выставляем значения по умолчанию
         * @see u.contextLimit.useEnableCPCHold - условия при которых не принимаем в расчет enable_cpc_hold
         */
        if (strategyField == 'options') {

            areStrategyDependableShows = u.contextLimit.areStrategyDependableShows(strategy.name, strategy.options);

            if (areStrategyDependableShows) {
                if (!this._contextLimitSavedState) {
                    this._contextLimitSavedState = u._.pick(this.model.toJSON(), [
                        'ContextLimit', 'ContextPriceCoef', 'enable_cpc_hold'
                    ]);
                }

                this.model
                    .update(
                        u._.pick(u.contextLimit.getDefaultValues(),
                        ['enable_cpc_hold', 'ContextLimit', 'ContextPriceCoef']
                    ))
                    .fix();
            } else if (this._contextLimitSavedState && !strategy.is_net_stopped) {
                this.model
                    .update(this._contextLimitSavedState)
                    .fix();

                this._contextLimitSavedState = null;
            }
        } else if (strategyField == 'is_net_stopped') {
            strategyValue ? this._disableContextLimit() : this._enableContextLimit();
        }

        this._updateContextLimitTextDebounce();

        return this;
    },

    /**
     * Отключены ли показы на тематических площадках
     * @returns {Boolean}
     * @private
     */
    _isContextSettingsTurnedOff: function() {
        var strategy2 = this.model.get('strategy2');
        return strategy2.get('is_net_stopped') || strategy2.get('name') === 'different_places'
    },

    /**
     * Формирует строку запрещённых площадок/внешних сетей, обновляет скрытый инпут DontShow
     * @private
     */
    _updateDisabledPlatforms: function() {
        // объединяем домены и ssp
        var platforms = [].concat(this.model.get('disabled_ssp'), this.model.get('DontShow'));

        this.elem('hidden', 'type', 'dont-show')
            .val(platforms.join(','));

        this.elem('hidden', 'type', 'require-filtration-by-dont-show-domains')
            .val(this.model.get('require_filtration_by_dont_show_domains') ? '1' : '0');

        BEM.DOM.update(this.elem('dont-show-wrap'), BEMHTML.apply({
            block: 'b-campaign-settings',
            elem: 'dont-show-hint',
            platforms: platforms.map(u.escapeHTML),
            isEditable: true
        }));
    },

    /**
     * Формирует строку запрещённых площадок/мобильный приложений
     * обновляет скрытый инпут disabled_video_placements
     * @private
     */
    _updateDisabledCpmVideo: function() {
        var platforms = this.model.get('disabled_video_placements');

        this.elem('hidden', 'type', 'dont-show-video').val(platforms.join(','));

        BEM.DOM.update(this.elem('dont-show-video-wrap'), BEMHTML.apply({
            block: 'b-campaign-settings',
            elem: 'dont-show-hint',
            platforms: platforms.map(u.escapeHTML),
            isEditable: true
        }));
    },

    /**
     * Инициализируем контролы настройки оптимизации показов
     * @private
     */
    _initEShowsControls: function() {
        this._eShowsBannerRateCheckbox = this.findBlockOn('eshows-banner-rate-checkbox', 'checkbox');
        this._eShowsVideoRateCheckbox = this.findBlockOn('eshows-video-rate-checkbox', 'checkbox');
        this._eShowsVideoTypeSelect = this.findBlockOn('eshows-video-type-input', 'select');

        if (this._eShowsBannerRateCheckbox) {
            this._subMan.on(this._eShowsBannerRateCheckbox, 'change', function(e, data) {
                if (data.checked) {
                    this.model.update({ eshows_banner_rate: 1 });
                } else {
                    this.model.update({ eshows_banner_rate: 0 });
                }
            }, this);
        }

        if (this._eShowsVideoRateCheckbox) {
            this._subMan.on(this._eShowsVideoRateCheckbox, 'change', function(e, data) {
                if (data.checked) {
                    this.model.update({ eshows_video_rate: 1 });
                    this._eShowsVideoTypeSelect.delMod('disabled');
                } else {
                    this.model.update({ eshows_video_rate: 0 });
                    this._eShowsVideoTypeSelect.setMod('disabled', 'yes');
                }
            }, this);
        }

    },

    /**
     * Инициализирует контрол задания ограничения частоты показов
     * @private
     */
    _initShowsFrequencyControl: function() {
        var mediaType = this.model.get('mediaType');

        this._showsFrequencyCheckbox = this.findBlockOn('shows-frequency-checkbox', 'checkbox');
        this._showsFrequencyControl = this.findBlockOn('shows-frequency-control', 'b-shows-frequency-control');

        if (!this._showsFrequencyCheckbox) {
            return;
        }

        this._subMan.on(this._showsFrequencyCheckbox, 'change', function(e, data) {
            if (data.checked) {
                this.delMod(this.elem('shows-frequency-control'), 'hidden');

                this._showsFrequencyControl.setMod('focused', 'yes');
            } else {
                this.setMod(this.elem('shows-frequency-control'), 'hidden', 'yes');

                this._showsFrequencyControl.reset();
            }
        }, this);

        // подписка на изменение модели по ограничению частоты показов
        // обновляет поля rf, rfReset в модели кампании
        // нужны для для построения превью прогноза и прогноза в попапе настроек стратегии
        // используется для автостратегий в медийных кампаниях
        if (mediaType === 'cpm_banner' || mediaType === 'cpm_yndx_frontpage') {
            this._subMan.on(BEM.MODEL.getOne('b-shows-frequency-control'), 'change', this._checkShowsFrequencyControl, this);
        }
    },

    /**
     * Проверяет на валидность ограничение частоты показов и обновляет соответствующие данные модели
     * @returns {$.Deferred|undefined}
     * @private
     */
    _checkShowsFrequencyControl: function() {
        var defer = $.Deferred(),
            showsFrequencyControlData;

        if (this._showsFrequencyCheckbox.isChecked()) {
            if (this._showsFrequencyControl.validate()) {
                showsFrequencyControlData = this._showsFrequencyControl.getData();

                this.model.update({
                    rf: showsFrequencyControlData.showsValue,
                    rfReset: showsFrequencyControlData.periodName === 'showsPeriod' ?
                        0 :
                        showsFrequencyControlData.periodValue
                });

                defer.resolveWith(this);
            } else {
                this.model.update({
                    rf: 0,
                    rfReset: undefined
                });

                defer.reject();
            }
        } else {
            this.model.update({
                rf: 0,
                rfReset: undefined
            });

            defer.resolveWith(this);
        }

        return defer;
    },

    /**
     * Связывает цепочку методов (можно асинхронных) и возвращает обещание
     * @param {...function} methodsp
     * @returns {$.Promise}
     * @private
     */
    _chain: function(methodsp) {
        // defer сразу резолвится и будут выполняться все добавляющиеся .pipe и .then
        var defer = $.Deferred(),
            methods = Array.prototype.slice.call(arguments);

        defer.resolveWith(this);

        u._.compact(methods)
            .forEach(function(method) {
                defer = defer.pipe(method);
            });

        return defer.promise();
    },

    /**
     * в рамках DIRECT-71249
     * при создании cpm кампании, сервер присылает дефолтную невалидную стратегию, пользователь должен ее настроить
     * @returns {*}
     * @private
     */
    _validateCpmStrategy: function() {
        var defer = $.Deferred(),
            strategy2 = this.model.get('strategy2').toJSON(),
            name = u._.get(strategy2, 'options.net.name'),
            net = u._.get(strategy2, 'options.net', {}),
            cpmPeriodStrategy = [
                'autobudget_max_reach_custom_period',
                'autobudget_max_impressions_custom_period',
                'autobudget_avg_cpv'
            ];

        if (cpmPeriodStrategy.indexOf(name) !== -1 && (!net.budget || !net.avg_cpm)) {
            BEM.blocks['b-confirm'].alert(iget2('b-campaign-settings', 'should-customize-strategy', 'Необходимо настроить стратегию'));
            $(window).scrollTop(this.findElem('item', 'of', 'strategy').offset().top);

            defer.reject();
        } else {
            defer.resolveWith(this);
        }

        return defer.promise();
    },

    /**
     * В РМП появился "быстрый доступ" к авто-стратегиям, там может быть невалидное состояние
     * @private
     */
    _validateRmpStrategy: function() {
        var defer = $.Deferred();

        if (this.blockInside('b-campaign-strategy2').isValid()) {
            defer.resolveWith(this);
        } else {
            if (this.blockInside('b-campaign-strategy2').hasMod('has-presetting', 'yes')) {
                $(window).scrollTop(this.findElem('item', 'of', 'strategy').offset().top);
                defer.reject();
            }
        }

        return defer.promise();
    },

    /**
     * По дефолту могут предлагаться стратегии "оптимизация конверсий",
     * "оптимизация кликов (недельный бюджет)", оптимизация рентабельности",
     * которую следует провалидировать перед отправкой на бэк
     * @private
     */
    _validateStrategy: function() {
        var defer = $.Deferred(),
            strategyModel = this.model.get('strategy2'),
            strategyName = strategyModel.get('name'),
            strategyOptions = strategyModel.get('options');

        if (
            (strategyName === u.strategy.AUTOBUDGET_AVG_CPA && strategyOptions.goal_id === undefined) ||
            (strategyName === u.strategy.AUTOBUDGET && !strategyOptions.sum) ||
            (
                strategyName === u.strategy.AUTOBUDGET_ROI &&
                (strategyOptions.roi_coef == null || strategyOptions.goal_id === undefined)
            )
        ) {
            BEM.blocks['b-confirm'].alert(iget2('b-campaign-settings', 'should-customize-strategy', 'Необходимо настроить стратегию'));
            $(window).scrollTop(this.findElem('item', 'of', 'strategy').offset().top);

            defer.reject();
        } else {
            defer.resolveWith(this);
        }

        return defer.promise();
    },

    /**
     * Проводит проверку модели
     * @returns {$.Deferred|undefined}
     * @private
     */
    _validateModel: function() {
        var defer;

        if (!this.model.isValid()) {
            defer = $.Deferred();

            $(window).scrollTop(this.domElem.offset().top);

            defer.reject();

            return defer;
        }
    },

    /**
     * Проверяет визитку
     * @returns {$.Deferred|undefined}
     * @private
     */
    _checkVcard: function() {
        var defer = $.Deferred();

        if (!this._vcard.validate()) {
            $(window).scrollTop(this._vcard.domElem.offset().top);

            defer.reject();

            return defer;
        }

        if (!(this.params.newCamp || this.params.continueCreating) &&
            //изменили визитку
            (this._vcard.isFormChanged() && this.model.get('with_ci') ||
                //удалили визитку
                !this.model.get('with_ci') && this.model.isChanged('with_ci'))) {

            defer = $.Deferred();

            BEM.blocks['b-confirm'].open({
                message: {
                    block: 'b-campaign-settings',
                    elem: 'alert-message',
                    content: [
                        iget2('b-campaign-settings', 'vy-izmenili-kontaktnuyu-informaciyu', 'Вы изменили контактную информацию!'),
                        '<br/>',
                        '<br/>',
                        this.model.get('with_ci') ?
                            iget2(
                                'b-campaign-settings',
                                'pri-sohranenii-ustanovlennaya-edinaya',
                                'При сохранении установленная ЕДИНАЯ контактная информация будет у всех объявлений одинаковой.'
                            ) :
                            iget2(
                                'b-campaign-settings',
                                'pri-sohranenii-ustanovlennaya-edinaya-108',
                                'При сохранении установленная ЕДИНАЯ контактная информация будет ОТМЕНЕНА!'
                            ),
                        '<br/>',
                        '<br/>',
                        iget2('b-campaign-settings', 'sohranit-109', 'Сохранить?')
                    ]
                },
                onYes: function() {
                    defer.resolveWith(this);
                },
                onNo: function() {
                    defer.reject();
                }
            }, this);

            return defer;
        }
    },

    /**
     * Делает проверку даты окончания кампании и выводит предупреждение
     * @returns {$.Deferred|undefined}
     * @private
     */
    _checkFinishDate: function() {
        var finish = this.model.get('finish_date'),
            defer;

        // если есть окончание кампании и оно раньше сегодняшнего дня
        if (finish && u.moment(finish).isBefore(u.moment(), 'day')) {
            defer = $.Deferred();

            BEM.blocks['b-confirm'].open({
                message: iget2(
                    'b-campaign-settings',
                    'ustanovlennaya-data-okonchaniya-kampanii',
                    'Установленная дата окончания кампании меньше текущей! Сохранить?'
                ),
                onYes: function() {
                    defer.resolveWith(this);
                },
                onNo: function() {
                    defer.reject();
                }
            }, this);

            return defer;
        }
    },

    /**
     * Проверяет поля status_click_track и statusOpenStat на изменение и показывает
     * предупреждение для пользователя
     * @returns {$.Deferred|undefined}
     * @private
     */
    _checkClickTracking: function() {
        var model = this.model,
            defer,
            text;

        // Если поля поменялись, то показываем предупреждение и по его закрытию резолвим обещание
        if (model.get('status_click_track') && model.isChanged('status_click_track')) {
            if (model.get('statusOpenStat') && model.isChanged('statusOpenStat')) {
                text =
                    iget2(
                        'b-campaign-settings',
                        'vnimanie-vmeste-s-vneshnimi',
                        'Внимание! Вместе с внешними системами статистики будет включена настройка разметки ссылок для Метрики. Вы можете отключить настройку в параметрах кампании'
                    );
            } else {
                text =
                    iget2(
                        'b-campaign-settings',
                        'vnimanie-v-ssylki-vedushchie',
                        'Внимание! В ссылки, ведущие с рекламного объявления, будет подставляться дополнительный параметр. Убедитесь в том, что использование параметров в URL не конфликтует с программным обеспечением вашего сайта и сервер корректно отображает соответствующие страницы'
                    );
            }

            defer = $.Deferred();

            BEM.blocks['b-confirm'].open({
                type: 'alert',
                message: {
                    block: 'b-campaign-settings',
                    elem: 'alert-message',
                    content: text
                },
                onYes: function() {
                    defer.resolveWith(this);
                }
            }, this);

            return defer;
        }
    },

    /**
     * Возвращает общий блок попапа
     * @return {BEM.DOM}
     * @private
     */
    _getSharedPopup: function() {
        return this._sharedPopup ||
            (this._sharedPopup = BEM.DOM.blocks['b-shared-popup'].getInstance(
                { animate: 'yes', 'has-close': 'yes' },
                { directions: ['right', 'bottom', 'top'] }
            ));
    },

    /**
     * Получение блока-обертки геотаргетинга
     * @returns {BEM}
     * @private
     */
    _getTimeTargetingPresenter: function() {
        return this._timeTargetingPresenter ||
            (this._timeTargetingPresenter = this.findBlockInside('b-time-targeting-presenter'))
    },

    /**
     * Обработчик изменения поля product_type модели кампании
     * @param {Event} e событие
     * @param {Object} data данные
     * @param {String} data.value тип продукта
     */
    _onProductTypeChange: function(e, data) {
        var campRegion = this.findBlockInside('b-campaign-region'),
            regionsSelector = campRegion.findBlockInside('b-regions-selector'),
            mcbRegions = u.REGIONS.MCB_DISABLED_REGIONS,
            isMcbRegional = data.value === 'mcb_regional';

        regionsSelector.setDisabledRegions(isMcbRegional ? mcbRegions : undefined);
        campRegion.toggleWarning(isMcbRegional);
    },

    /**
     * Обновляет состояние контрола выбора ключевых целей
     * @param {String} cid идентификатор кампании
     * @param {String} metrikaCounters идентификаторы счетчиков метрики
     */
    _updateKeyGoals: function(cid, metrikaCounters) {
        var model = this.model,
            keyGoalsControlElem = this.elem('key-goals-control'),
            isReadOnly = this.getMod(keyGoalsControlElem, 'readonly') === 'yes';

        BEM.DOM.update(
            keyGoalsControlElem,
            BEMHTML.apply({
                block: 'spin',
                js: true,
                mods: { progress: 'yes', theme: 'gray-16' }
            })
        );

        BEM.blocks['i-meaningful-goals-dataprovider'].getGoals(cid, metrikaCounters)
            .then(function(goals) {
                var value = model.get('meaningful_goals') || [];

                if (u._.size(goals) === 0) {
                    value = [];
                    model.set('meaningful_goals', []);
                }

                BEM.DOM.update(
                    keyGoalsControlElem,
                    BEMHTML.apply({
                        block: 'b-metrics-key-goals',
                        mods: {
                            readonly: isReadOnly ? 'yes' : ''
                        },
                        goals: u.goals.transformGoalsFromServerFormat(goals),
                        value: u.goals.transformValueFromServerFormat(value),
                        currency: model.get('currency'),
                        hiddenControlName: 'json_meaningful_goals',
                        modelParams: {
                            name: model.name,
                            id: model.id
                        },
                        strategyData: model.get('strategy2').toJSON()
                    })
                )
            })
            .catch(function(e) {
                BEM.DOM.update(
                    keyGoalsControlElem,
                    iget2('b-metrics-key-goals', 'server-error', 'Невозможно загрузить ключевые цели')
                );
            });
    },

    /**
     * Инициализирует контрол выбора ключевых целей
     * @override
     */
    _initKeyGoalsControl: function() {
        var keyGoalsControl = this.elem('key-goals-control'),
            model = this.model;

        if (keyGoalsControl.length === 0) {
            return;
        }

        this._subMan.on(model, 'metrika_counters', 'change', function() {
            this._updateKeyGoals(model.get('cid'), model.get('metrika_counters'));
        }, this);
    },

    /**
     * Инициализирует контрол выбора ключевых целей
     * @override
     */
    _initExperimentsControl: function() {
        var experimentsControl = this.elem('experiments-control'),
            model = this.model;

        if (experimentsControl.length === 0) {
            return;
        }

        this._subMan.on(model, 'metrika_counters', 'change', function() {
            this.blockInside('experiments-control', 'b-experiments-settings').updateCounters(model.get('metrika_counters'));
        }, this);
    },

    _initRmpGoalControl: function() {
        var rmpGoalControl = this.blockInside('rmp-goal', 'radio-button'),
            currentValue = rmpGoalControl.val();

        if (!this.params.newCamp) {
            rmpGoalControl.delMod(rmpGoalControl.elem('radio', 'name', currentValue), 'disabled');
        }

    },

    _initMobileAppSelectControl: function() {
        var value = this._mobileAppSelect.getValue();

        if (u._.get(value, 'id')) {
            this._submitButton.delMod('disabled');

            if (this.elem('rmp-goal').length) {
                this._updateRmpGoalStatus(value);
            }

            if (this.blockInside('b-campaign-strategy2')) {
                this.blockInside('b-campaign-strategy2').allowAvgCPI(value.trackers.length !== 0);
            }
        } else {
            this._submitButton.setMod('disabled', 'yes');
            this.blockInside('b-campaign-strategy2').allowAvgCPI(false);
        }

        this._subMan.on(this._mobileAppSelect, 'select', function(e, data) {
            var geo = data.geoTargeting || [],
                regionSelector = this._region.blockInside('b-regions-selector'),
                regionIds = geo.join(),
                selectedRegionIds = regionSelector.getGeoModel().get('geo') || ''; // id региона(ов)

            this._submitButton.delMod('disabled');

            this.model.set('selected_mobile_app', data);

            if (this.elem('rmp-goal').length) {
                this._updateRmpGoalStatus(data);
            }

            if (this.blockInside('b-campaign-strategy2')) {
                this.blockInside('b-campaign-strategy2').allowAvgCPI(data.trackers.length !== 0);
            }

            if (this._region) {
                if (!selectedRegionIds.length) {
                    regionSelector.setSelectedRegions(regionIds);
                } else if (regionIds !== selectedRegionIds) {
                    var warning = (regionIds || '').length ?
                        iget2('b-campaign-settings', 'change-current-region', 'Изменить регион показа на {regions}?', {
                            regions: u.getGeoNames(regionIds)
                        }) :
                        iget2('b-campaign-settings', 'reset-current-region', 'Сбросить регион показа?');

                    BEM.blocks['b-confirm'].open({
                        message: warning,
                        onYes: function() {
                            regionSelector.setSelectedRegions(regionIds);
                        }
                    });
                }
            }

            // Если было предупреждение о выборе приложения, убираем его
            if (this.elem('select-app-warning')) {
                this.elem('select-app-warning').remove();
            }
        }, this);
    },

    _initAloneTrafaretCheckbox: function() {
        if (!this._aloneTrafaretCheckbox) {
            return;
        }

        this._aloneTrafaretDisabled = this.model.get('strategy2').get('is_search_stopped');
        this._aloneTrafaretTooltip.setOwner(this._aloneTrafaretCheckbox);

        $(this._aloneTrafaretCheckbox.domElem).hover(function() {
            if (this._aloneTrafaretDisabled) {
                this._aloneTrafaretTooltip.setMod('shown', 'yes');
            }
        }.bind(this), function() {
            this._aloneTrafaretTooltip.delMod('shown');
        }.bind(this));

        this._subMan.wrap(this.model.get('strategy2'))
            .on('is_search_stopped', 'change', function(event, data) {
                this._aloneTrafaretCheckbox.setMod('disabled', data.value ? 'yes' : '');
                this._aloneTrafaretDisabled = data.value;
            }, this);
    },

    _prepareAloneTrafaretInput: function() {
        var value;

        if (!this._aloneTrafaretCheckbox) {
            return;
        }

        value = this._aloneTrafaretDisabled ?
            undefined :
            this._aloneTrafaretCheckbox.hasMod('checked', 'yes') ?
                1 :
                0;

        this._aloneTrafaretHidden.val(value)
    },

    _deinitAloneTrafaretCheckbox: function() {
        if (!this._aloneTrafaretCheckbox) {
            return;
        }
        $(this._aloneTrafaretCheckbox.domElem).off('mouseenter mouseleave');
    },

    _updateRmpGoalStatus: function(data) {
        var rmpGoalControl = this.blockInside('rmp-goal', 'radio-button');

        if (rmpGoalControl.hasMod('disabled') && (this.params.newCamp || this.params.continueCreating)) {
            rmpGoalControl.delMod('disabled');
        }

        if (data.trackers.length === 0) {
            rmpGoalControl.setMod(rmpGoalControl.elem('radio', 'name', 'installs'), 'disabled', 'yes');
            rmpGoalControl.val('clicks');
        } else {
            rmpGoalControl.delMod(rmpGoalControl.elem('radio', 'name', 'installs'), 'disabled');
            rmpGoalControl.val('installs');
        }
    },

    _initRestrictionTypeControl: function() {
        if (!this._restrictionTypeRadio.val()) {
            this._restrictionTypeRadio.val(this.model.get('restriction_type'));
        }

        if (!this._restrictionInput.val()) {
            this._restrictionInput.val(this.model.get('restriction_value_by_type'));
        }

        this._subMan.on(this.model, 'restriction_value_by_type', 'change', function() {
            this._restrictionInput.val(this.model.get('restriction_value_by_type'));
        }, this);
    },

    /**
     * замеряем процент отвала клиентов, которым по дефолту предлагается конверсионная стратегия "оптимизация конверсий"
     * @param {String} mediaType - тип кампании
     * @private
     */
    _reachMetrikaGoalsOnInit: function(mediaType) {
        var isDefaultAutobudgetAvgCpaFeatureEnabled = u.consts('isDefaultAutobudgetAvgCpaEnabled'),
            isDefaultAutobudgetOptimizeClicksEnabled = u.consts('isDefaultAutobudgetOptimizeClicksEnabled'),
            isDefaultAutobudgetRoiFeatureEnabled = u.consts('isDefaultAutobudgetRoiEnabled'),
            metrika;

        if (!['text', 'dynamic', 'performance'].includes(mediaType) || !this._strategy || !this.params.newCamp) {
            return;
        }

        metrika = BEM.blocks['b-metrika2'];

        metrika.reachGoal({
            target: 'session-started-for-' + mediaType + '-campaign-create',
            params: {
                isDefaultAutobudgetAvgCpaFeatureEnabled: isDefaultAutobudgetAvgCpaFeatureEnabled,
                isDefaultAutobudgetOptimizeClicksEnabled: isDefaultAutobudgetOptimizeClicksEnabled,
                isDefaultAutobudgetRoiFeatureEnabled: isDefaultAutobudgetRoiFeatureEnabled
            }
        });

        // итоговое событие сохранения кампании со стратегией в методе _reachMetrikaGoals
    },

    /**
     * проверяем выбранные запрещенные площадки на наличие внутреннмх площадок
     * @param {String} type - тип фильтруемых площадок для показа предупреждения
     * @param {String} modelField - название поля модели со списком площадок
     * @private
     */
    _checkHasDontShowInternalSites: function(type, modelField) {
        BEM.blocks['i-web-api-request'].disabledDomains.getInternalPagesDomains(
            u.consts('ulogin'),
            this.model.get(modelField)
        )
            .then(function(internalSites) {
                this._hasDontShowInternalSites[type] = !!internalSites.length;
                this._setDontShowInternalSitesWarningVisibility(type);
            }.bind(this))
            .catch(function() { /* skip */ });
    },

    /**
     * устанавливаем видимость предупреждения про запрещенные площадки
     * @param {String} type - тип фильтруемых площадок для показа предупреждения
     * @private
     */
    _setDontShowInternalSitesWarningVisibility: function(type) {
        var warningElem = this.elem('item', 'dont-show', type),
            strategyModel = this.model.get('strategy2');

        if (!warningElem) {
            return;
        }

        if (this._hasDontShowInternalSites[type] && !strategyModel.get('is_net_stopped')) {
            this.setMod(warningElem, 'visible', 'yes');
        } else {
            this.delMod(warningElem, 'visible');
        }
    }
});
