block('b-campaign-settings').mod('type', 'cpm-banner')(
    extend()(function() {

        return {
            modelParams: this.data.campaign.dmParams
        };
    }),

    js()(function() {
        var modelData = this.data.campaign,
            strategy = modelData.strategy2 || {};

        modelData.status_click_track = !!+modelData.status_click_track;

        return {
            modelName: this.modelParams.name,
            modelId: this.modelParams.id,
            modelData: this.extend(modelData, {
                is_autobudget: !!+strategy.is_autobudget,
                multipliersPct: u['i-adjustment-rates-data'].getMultipliersPct(modelData.hierarchical_multipliers)
            })
        };
    }),

    mode('groupsOfSettings')(function() {

        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('manageShows'),
            apply('eshowsOptimization'),
            apply('metrics'),
            apply('experiments'),
            apply('managePlatforms'),
            apply('notifications'),
            apply('expand'),
            apply('manager')
        ];
    }),

    mode('manageShows')(function() {
        var isFeatureBrandSafetyEnabled = u.consts('isFeatureBrandSafetyEnabled'),
            isFeatureBrandLiftEnabled = !!this.data.is_feature_brand_lift_enabled,
            campaign = this.data.campaign,
            all_retargeting_conditions = this.data.all_retargeting_conditions;

        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx(u._.compact([
                { elem: 'item', elemMods: { of: 'strategy' } },
                hasEnabledFeatures('impression_standard_time') ?
                    { elem: 'item', elemMods: { of: 'impression-standard' } } :
                    '',
                // для cpm_banner доступна только корректировка по типу группы и то пока под фичей
                u.consts('rights').allowedCpmVideoBanners ?
                    {
                        elem: 'item',
                        elemMods: { of: 'adjustment-rates' },
                        campaign: campaign,
                        all_retargeting_conditions: all_retargeting_conditions,
                        data: {
                            tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                                cpmGroupType: true
                            })
                        }
                    } :
                    false,
                isFeatureBrandLiftEnabled ?
                    { elem: 'item', elemMods: { of: 'brand-lift' } } :
                    '',
                { elem: 'item', elemMods: { of: 'shows-frequency' } },
                { elem: 'item', elemMods: { of: 'metrics-control' } },
                isFeatureBrandSafetyEnabled ?
                    { elem: 'item', elemMods: { of: 'brand-safety' } } :
                    ''
            ]))
        };
    }),

    mode('managePlatforms')(function() {

        return {
            name: iget2('b-campaign-settings', 'upravlenie-ploshchadkami', 'Управление площадками'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'dont-show' } },
                { elem: 'item', elemMods: { of: 'dont-show-warning', 'dont-show': 'common' } },
                { elem: 'item', elemMods: { of: 'dont-show-video' } },
                { elem: 'item', elemMods: { of: 'dont-show-warning', 'dont-show': 'video' } }
            ])
        };
    }),

    mode('expand')(function() {

        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'device-targeting' } },
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },
                { elem: 'item', elemMods: { of: 'content-lang' } },
                { elem: 'item', elemMods: { of: 'description' } },
                { elem: 'item', elemMods: { of: 'favorite' } },
                { elem: 'item', elemMods: { of: 'allowed-page-ids' } }
            ])
        };
    }),

    mode('eshowsOptimization')(function() {
        return {
            name: iget2('b-campaign-settings', 'shows-optimization', 'Оптимизация показов'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'eshows-banners' } },
                { elem: 'item', elemMods: { of: 'eshows-video' } }
            ])
        };
    })
);
