block('b-campaign-settings').mod('type', 'cpm-price')(
    extend()(function() {

        return {
            modelParams: this.data.campaign.dmParams
        };
    }),

    js()(function() {
        var modelData = this.data.campaign,
            strategy = modelData.strategy2 || {};

        modelData.status_click_track = !!+modelData.status_click_track;
        modelData.isCreatingNewCamp = this.data.new_camp;

        return {
            modelName: this.modelParams.name,
            modelId: this.modelParams.id,
            modelData: this.extend(modelData, {
                is_autobudget: !!+strategy.is_autobudget
            })
        };
    }),

    mode('groupsOfSettings')(function() {

        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('manageShows'),
            apply('metrics'),
            apply('managePlatforms'),
            apply('notifications'),
            apply('expand'),
            apply('manager')
        ];
    }),

    mode('geography')(function() {
        return {
            name: iget2('b-campaign-settings', 'geografiya', 'География'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'geo' } }
            ])
        };
    }),

    mode('manageShows')(function() {

        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'strategy' } },
                { elem: 'item', elemMods: { of: 'metrics-control' } }
            ])
        };
    }),

    mode('managePlatforms')(function() {

        return {
            name: iget2('b-campaign-settings', 'upravlenie-ploshchadkami', 'Управление площадками'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'allowed-frontpage-types' } }
            ])
        };
    }),

    mode('expand')(function() {

        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'device-targeting' } },
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },
                { elem: 'item', elemMods: { of: 'content-lang' } },
                { elem: 'item', elemMods: { of: 'description' } },
                { elem: 'item', elemMods: { of: 'favorite' } },
                { elem: 'item', elemMods: { of: 'allowed-page-ids' } }
            ])
        };
    })
);
