block('b-campaign-settings').mod('type', 'internal-free')(

    extend()(function() {
        return {
            modelParams: this.data.campaign.dmParams
        };
    }),

    js()(function() {
        var modelData = this.data.campaign,
            strategy = modelData.strategy2 || {};

        modelData.status_click_track = !!+modelData.status_click_track;

        return {
            modelName: this.modelParams.name,
            modelId: this.modelParams.id,
            modelData: this.extend(modelData, {
                is_autobudget: !!+strategy.is_autobudget
            })
        };
    }),

    mode('groupsOfSettings')(function() {

        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('manageShows'),
            apply('metrics'),
            apply('advertisedService'),
            apply('managePlatforms'),
            apply('internalRestriction'),
            apply('notifications'),
            apply('expand')
        ];
    }),

    mode('geography')(function() {
        return {
            name: iget2('b-campaign-settings', 'geografiya', 'География'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'geo' } }
            ])
        };
    }),

    mode('manageShows')(function() {

        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx(u._.compact([
                { elem: 'item', elemMods: { of: 'shows-frequency' } },
                // скрыто для пользователя
                { elem: 'item', elemMods: { of: 'metrics-control' } }
            ]))
        };
    }),

    mode('metrics')(function() {
        return {
            name: iget2('b-campaign-settings', 'metrika', 'Метрика'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'metrika-failed-warning' } },
                { elem: 'item', elemMods: { of: 'metrics-counters' } },
                { elem: 'item', elemMods: { of: 'metrics-key-goals' } },
                { elem: 'item', elemMods: { of: 'metrics-attribution' } }
            ])
        };
    }),

    mode('advertisedService')(function() {

        return {
            name: iget2('b-campaign-settings', 'advertised-service', 'Рекламируемый сервис'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'internal-product-name' } },
                { elem: 'item', elemMods: { of: 'internal-is-mobile' } }
            ])
        };
    }),

    mode('managePlatforms')(function() {

        return {
            name: iget2('b-campaign-settings', 'upravlenie-ploshchadkami', 'Управление площадками'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'internal-place-id' } },
                { elem: 'item', elemMods: { of: 'internal-page-ids' } }
            ])
        };
    }),

    mode('internalRestriction')(function() {
        return {
            name: iget2('b-campaign-settings', 'internal-restriction', 'Ограничения'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'internal-restriction-type' } },
                { elem: 'item', elemMods: { of: 'internal-restriction-value' } }
            ])
        };
    }),

    mode('expand')(function() {

        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'favorite' } }
            ])
        };
    })
);
