block('b-campaign-settings').mod('type', 'mcbanner')(
    extend().match(function() {
        return !this.modelParams;
    })(function() {
        return {
            modelParams: {
                name: 'm-campaign',
                id: this.data.campaign.cid
            }
        };
    }),

    js()(function() {
        var modelData = this.data.campaign,
            strategy = modelData.strategy2 || {};

        modelData.status_click_track = !!+modelData.status_click_track;

        return {
            modelName: this.modelParams.name,
            modelId: this.modelParams.id,
            // TODO: возможно, потребуются другие параметры для стратегий
            modelData: this.extend(modelData, {
                is_autobudget: !!+strategy.is_autobudget
            }),
            newCamp: this.data.new_camp,
            continueCreating: this.data.continue_creating
        };
    }),

    // убираем визитку
    mode('groupsOfSettings')(function() {
        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('manageShows'),
            apply('phrases'),
            apply('metrics'),
            apply('experiments'),
            apply('notifications'),
            apply('expand'),
            apply('manager')
        ];
    }),

    mode('manageShows')(function() {
        var campaign = this.data.campaign,
            all_retargeting_conditions = this.data.all_retargeting_conditions;

        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'strategy' } },
                { elem: 'item', elemMods: { of: 'adjustment-rates' },
                    campaign: campaign,
                    all_retargeting_conditions: all_retargeting_conditions
                },
                { elem: 'item', elemMods: { of: 'metrics-control' } }
            ])
        };
    }),

    mode('expand')(function() {
        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                {
                    elem: 'item',
                    elemMods: { of: 'dont-show' },
                    title: iget2('b-campaign-settings', 'zapreshchennye-ploshchadki', 'Запрещенные площадки'),
                    needOuterNets: false,
                    useBanner: true
                },
                { elem: 'item', elemMods: { of: 'minus-words' } },
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },
                { elem: 'item', elemMods: { of: 'content-lang' } },
                { elem: 'item', elemMods: { of: 'description' } },
                { elem: 'item', elemMods: { of: 'favorite' } }
            ])
        };
    })
);
