block('b-campaign-settings').mod('type', 'mobile-content')(

    extend()(function() {
        return {
            modelParams: {
                name: 'dm-mobile-content-campaign',
                id: this.data.campaign.cid
            }
        };
    }),

    addMix()(function() {
        return [
            {
                block: 'i-glue',
                js: {
                    modelParams: {
                        name: 'b-campaign-settings_type_mobile-content',
                        id: this.data.campaign.cid
                    }
                }
            }
        ];
    }),

    js()(function() {
        return {
            modelParams: this.modelParams,
            disableValidation: this.data.disable_client_validation && this.data.disable_client_validation != '0',
            newCamp: this.data.new_camp,
            continueCreating: this.data.continue_creating
        };
    }),

    prependContent()(function() {
        var modelParams = this.modelParams;

        return {
            block: 'i-model',
            modelParams: {
                name: modelParams.name,
                id: modelParams.id,
                data: applyCtx({
                    block: modelParams.name,
                    campaign: this.data.campaign
                })
            }
        };
    }),

    def()(function() {
        this.ctx.mods['view'] = 'simple';
        return applyNext();
    }),

    mode('groupsOfSettings')(function() {
        return [
            apply('name'),
            apply('main'),
            apply('expand'),
            apply('manager')
        ];
    }),

    mode('vcard')(''),

    mode('metrics')(''),

    mode('manageShows')(function() {
        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'strategy' } },
                { elem: 'item', elemMods: { of: 'context-limit' } },
                {
                    elem: 'item',
                    elemMods: { of: 'adjustment-rates' },
                    data: {
                        defaultTab: 'demography',
                        tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                            demography: true,
                            retargeting: true,
                            hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                                this.data.all_retargeting_conditions,
                                'metrika_goals'
                            )
                        })
                    }
                }
            ])
        };
    }),

    mode('targeting')(function() {
        return {
            name: iget2('b-campaign-settings', 'targeting-na-ustroystva', 'Таргетинг на устройства'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'targeting-type' } },
                { elem: 'item', elemMods: { of: 'targeting-network' } }
            ])
        };
    }),

    mode('main')(function() {
        return {
            mixes: [{ elem: 'hidden-name' }],
            cells: applyCtx([
                {
                    left: {
                        block: this.block,
                        elem: 'group-settings-header',
                        content: iget2('b-campaign-settings', 'main-settings', 'Основные настройки')
                    }
                },
                { elem: 'item', elemMods: { of: 'geo' } },
                // Временно закрашиваем - DIRECT-89503
                // { elem: 'item', elemMods: { of: 'rmp-goal' } },
                { elem: 'item', elemMods: { of: 'strategy' } },
                {
                    elem: 'item',
                    elemMods: { of: 'period' },
                    title: iget2('b-campaign-settings', 'period-campaign-text', 'Даты проведения'),
                    controlMods: { type: 'short' }
                }
            ])
        };
    }),

    mode('expand')(function() {
        var campaign = this.data.campaign,
            all_retargeting_conditions = this.data.all_retargeting_conditions;

        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'expand-settings', 'Расширенные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'minus-words' } },

                { elem: 'item', elemMods: { of: 'targeting-type' } },
                { elem: 'item', elemMods: { of: 'targeting-network' } },
                { elem: 'item', elemMods: { of: 'context-limit' } },

                { elem: 'item', elemMods: { of: 'timetargeting' } },
                {
                    elem: 'item',
                    elemMods: { of: 'adjustment-rates' },
                    data: {
                        defaultTab: 'demography',
                        tabsHash: u['b-adjustment-rates-popup'].getTabsHash({
                            demography: true,
                            retargeting: true,
                            hasRetargetingConditions: u.retargeting.hasRetargetingConditions(
                                this.data.all_retargeting_conditions,
                                'metrika_goals'
                            )
                        })
                    },
                    campaign: campaign,
                    all_retargeting_conditions: all_retargeting_conditions
                },
                { elem: 'item', elemMods: { of: 'dont-show' } },
                { elem: 'item', elemMods: { of: 'dont-show-warning', 'dont-show': 'common' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },

                { elem: 'item', elemMods: { of: 'banners-per-page' } },

                { elem: 'item', elemMods: { of: 'notifications' } },
                { elem: 'item', elemMods: { of: 'sms-warnings' } },

                { elem: 'item', elemMods: { of: 'content-lang' } },
                { elem: 'item', elemMods: { of: 'favorite' } },
                { elem: 'item', elemMods: { of: 'extended-geotargeting' } },
                { elem: 'item', elemMods: { of: 'alone-trafaret' } },
                { elem: 'item', elemMods: { of: 'description' } },
                { elem: 'item', elemMods: { of: 'allowed-page-ids' } }
            ])
        };
    })
);
