BEM.MODEL.decl({ name: 'b-campaign-settings_type_mobile-content', baseModel: 'vm-sync-dm2' }, {

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        calculate: function() {
            return {
                'dm-mobile-content-campaign': {
                    name: 'dm-mobile-content-campaign',
                    id: this.id
                }
            };
        }
    },

    // Id модели и кампнаии
    cid: 'string',

    // Тип устройства для таргетирования
    deviceType: {
        type: 'string',
        preprocess: function(val) {
            return val && u._.isArray(val) ? val.join(',') : val;
        }
    },

    // Тип связи для таргетирования
    network: {
        type: 'string',
        preprocess: function(val) {
            return val && u._.isArray(val) ? val.join(',') : val;
        }
    }

}, {

    init: function() {
        var dm = this.getDM()['dm-mobile-content-campaign'];

        this.set('deviceType', dm.get('device_type_targeting'));

        dm.on('device_type_targeting', 'change', function() {
            this.set('deviceType', dm.get('device_type_targeting'));
        }, this);
        this.on('deviceType', 'change', function() {
            dm.set('device_type_targeting', this.get('deviceType').split(','));
        }, this);

        this.set('network', dm.get('network_targeting'));

        dm.on('network_targeting', 'change', function() {
            this.set('network', dm.get('network_targeting'));
        }, this);
        this.on('network', 'change', function() {
            dm.set('network_targeting', this.get('network').split(','));
        }, this);
    }
});
