block('b-campaign-settings').mod('type', 'performance')(
    extend().match(function() {
        return !this.modelParams;
    })(function() {
        return {
            modelParams: {
                name: 'dm-dynamic-media-campaign',
                id: this.data.campaign.cid
            }
        };
    }),

    js()(function() {
        return {
            modelParams: this.modelParams,
            disableValidation: this.data.disable_client_validation && this.data.disable_client_validation != '0',
            newCamp: this.data.new_camp,
            continueCreating: this.data.continue_creating
        };
    }),

    prependContent()(function() {
        var modelParams = this.modelParams;

        return {
            block: 'i-model',
            modelParams: {
                name: modelParams.name,
                id: modelParams.id,
                data: applyCtx({
                    block: modelParams.name
                })
            }
        };
    }),

    mode('groupsOfSettings')(function() {
        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('metrics'),
            apply('experiments'),
            apply('manageShows'),
            apply('phrases'),
            apply('notifications'),
            apply('expand'),
            apply('manager'),
            apply('turbo-smarts')
        ];
    }),

    mode('geography')(function() {
        return {
            name: iget2('b-campaign-settings', 'geografiya', 'География'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'geo' } }
            ])
        };
    }),

    mode('metrics')(function() {
        return {
            name: iget2('b-campaign-settings', 'metrika', 'Метрика'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'metrika-failed-warning' } },
                { elem: 'item', elemMods: { of: 'metrics-counters' } },
                { elem: 'item', elemMods: { of: 'metrics-key-goals' } },
                { elem: 'item', elemMods: { of: 'metrics-attribution' } },
                { elem: 'item', elemMods: { of: 'metrics-links' } }
            ])
        };
    }),

    mode('manageShows')(function() {
        var campaign = this.data.campaign,
            all_retargeting_conditions = this.data.all_retargeting_conditions;

        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'metrika-failed-warning' } },
                { elem: 'item', elemMods: { of: 'strategy' } },
                {
                    elem: 'item',
                    elemMods: { of: 'adjustment-rates' },
                    campaign: campaign,
                    all_retargeting_conditions: all_retargeting_conditions
                }
            ])
        };
    }),

    mode('expand')(function() {
        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                {
                    elem: 'item',
                    elemMods: { of: 'dont-show' },
                    useBanner: true
                },
                { elem: 'item', elemMods: { of: 'dont-show-warning', 'dont-show': 'common' } },
                { elem: 'item', elemMods: { of: 'minus-words' } },
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },
                { elem: 'item', elemMods: { of: 'description' } },
                u.consts('turboAppAllowed') && { elem: 'item', elemMods: { of: 'turbo-app' } },
                { elem: 'item', elemMods: { of: 'favorite' } },
                { elem: 'item', elemMods: { of: 'alone-trafaret' } }
            ])
        };
    }),

    mode('turbo-smarts')(function() {
        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'turbo-smarts' }],
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'turbo-smarts' } }
            ])
        }
    })
);
