block('b-campaign-settings').mod('type', 'text')(
    extend().match(function() {
        return !this.modelParams;
    })(function() {
        return {
            modelParams: {
                name: 'm-campaign',
                id: this.data.campaign.cid
            }
        };
    }),

    js()(function() {
        var modelData = this.data.campaign,
            strategy = modelData.strategy2 || {};

        modelData.broad_match_flag = !!+modelData.broad_match_flag;
        modelData.status_click_track = !!+modelData.status_click_track;
        modelData.dialog_name = modelData.dialog && modelData.dialog.name;
        modelData.dialog_id = modelData.dialog && modelData.dialog.id;

        return {
            modelName: this.modelParams.name,
            modelId: this.modelParams.id,
            modelData: this.extend(modelData, {
                is_autobudget: !!+strategy.is_autobudget,
                with_ci: !!this.data.campaign.vcard && this.data.campaign.vcard.city
            }),
            newCamp: this.data.new_camp,
            continueCreating: this.data.continue_creating
        };
    }),

    mode('groupsOfSettings')(function() {
        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('manageShows'),
            apply('phrases'),
            apply('vcard'),
            apply('metrics'),
            apply('chats'),
            apply('experiments'),
            apply('notifications'),
            apply('expand'),
            apply('manager')
        ];
    }),

    mode('manageShows')(function() {
        var isFeatureBrandSafetyEnabled = u.consts('isFeatureBrandSafetyEnabled'),
            campaign = this.data.campaign,
            all_retargeting_conditions = this.data.all_retargeting_conditions;

        return {
            name: iget2('b-campaign-settings', 'upravlenie-pokazami', 'Управление показами'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'metrika-failed-warning' } },
                { elem: 'item', elemMods: { of: 'strategy' } },
                { elem: 'item', elemMods: { of: 'context-limit' } },
                { elem: 'item', elemMods: { of: 'adjustment-rates' },
                    campaign: campaign,
                    all_retargeting_conditions: all_retargeting_conditions
                },
                { elem: 'item', elemMods: { of: 'metrics-control' } },
                isFeatureBrandSafetyEnabled ?
                    { elem: 'item', elemMods: { of: 'brand-safety' } } :
                    ''
            ])
        };
    }),

    mode('chats').match(function() {
        return !!this.data.allowed_dialog_feature;
    })(function() {
        return {
            name: [
                iget2('b-campaign-settings', 'chats', 'Диалоги')
            ],
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'yandex-dialogs' } }
            ])
        };
    }),

    mode('expand')(function() {
        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'device-targeting' } },
                { elem: 'item', elemMods: { of: 'dont-show' } },
                { elem: 'item', elemMods: { of: 'dont-show-warning', 'dont-show': 'common' } },
                { elem: 'item', elemMods: { of: 'minus-words' } },
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },
                { elem: 'item', elemMods: { of: 'text-substitution' } },
                { elem: 'item', elemMods: { of: 'show-permalink-info' } },
                { elem: 'item', elemMods: { of: 'competitors' } },
                { elem: 'item', elemMods: { of: 'content-lang' } },
                { elem: 'item', elemMods: { of: 'description' } },
                { elem: 'item', elemMods: { of: 'favorite' } },
                { elem: 'item', elemMods: { of: 'alone-trafaret' } },
                { elem: 'item', elemMods: { of: 'allowed-page-ids' } }
            ])
        };
    })
);
