block('b-campaign-settings')(
    mode('groupsOfSettings')(function() {
        return [
            apply('name'),
            apply('shows'),
            apply('geography'),
            apply('manageShows'),
            apply('phrases'),
            apply('vcard'),
            apply('metrics'),
            apply('experiments'),
            apply('notifications'),
            apply('expand'),
            apply('manager')
        ];
    }),

    mode('name')(function() {
        return {
            name: '&nbsp',
            mixes: { block: 'b-campaign-settings', elem: 'campaign-name-group' },
            cells: applyCtx([
                { elem: 'server-error' },
                { elem: 'warning' },
                { elem: 'item', elemMods: { of: 'choose-agency' } },
                { elem: 'item', elemMods: { of: 'name' } },
                { elem: 'item', elemMods: { of: 'mobile-app' } }
            ])
        };
    }),

    mode('shows')(function() {
        return {
            name: iget2('b-campaign-settings', 'raspisanie-pokazov', 'Расписание показов'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'period' } },
                { elem: 'item', elemMods: { of: 'timetargeting' } }
            ])
        };
    }),

    mode('geography')(function() {
        return {
            name: iget2('b-campaign-settings', 'geografiya', 'География'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'geo' } },
                { elem: 'item', elemMods: { of: 'extended-geotargeting' } }
            ])
        };
    }),

    mode('manager').match(function() {
        return (
            this.data.OtherManagerUID && !hasLoginRights('manager_control', 'agency_control', 'support_control') ||
                    this.data.new_camp && hasLoginRights('manager_control')
        );
    })(function() {
        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'manager-servicing' }],
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'empty-campaign' } }
            ])
        };
    }),

    mode('experiments').match(function() {
        return !!this.data.is_ab_segments_enabled;
    })(function() {
        return {
            name: iget2('b-campaign-settings', 'experiments', 'Эксперименты'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'metrika-failed-warning' } },
                { elem: 'item', elemMods: { of: 'experiments' } }
            ])
        };
    }),

    mode('notifications')(function() {
        return {
            name: iget2('b-campaign-settings', 'uvedomleniya', 'Уведомления'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'notifications' } },
                { elem: 'item', elemMods: { of: 'sms-warnings' } }
            ])
        };
    }),

    mode('vcard')(function() {
        return {
            name: iget2('b-campaign-settings', 'vizitka', 'Визитка'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'vcard' } }
            ])
        };
    }),

    mode('metrics')(function() {
        return {
            name: iget2('b-campaign-settings', 'metrika', 'Метрика'),
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'metrika-failed-warning' } },
                { elem: 'item', elemMods: { of: 'metrics-counters' } },
                { elem: 'item', elemMods: { of: 'metrics-key-goals' } },
                { elem: 'item', elemMods: { of: 'metrics-attribution' } },
                { elem: 'item', elemMods: { of: 'metrics-links' } },
                { elem: 'item', elemMods: { of: 'external-stat' } }
            ])
        };
    }),

    mode('expand')(function() {
        return {
            mixes: [{ block: 'b-campaign-settings', elem: 'expand' }],
            name: iget2('b-campaign-settings', 'specialnye-nastroyki', 'Специальные настройки'),
            type: 'expander',
            mixName: 'b-campaign-settings',
            state: 'off',
            cells: applyCtx([
                { elem: 'item', elemMods: { of: 'device-targeting' } },
                { elem: 'item', elemMods: { of: 'dont-show' } },
                { elem: 'item', elemMods: { of: 'minus-words' } },
                { elem: 'item', elemMods: { of: 'banners-per-page' } },
                { elem: 'item', elemMods: { of: 'disabled-ips' } },
                { elem: 'item', elemMods: { of: 'text-substitution' } },
                { elem: 'item', elemMods: { of: 'show-permalink-info' } },
                { elem: 'item', elemMods: { of: 'competitors' } },
                { elem: 'item', elemMods: { of: 'content-lang' } },
                { elem: 'item', elemMods: { of: 'description' } },
                { elem: 'item', elemMods: { of: 'favorite' } }
            ])
        };
    })
);
