block('b-campaign-stat-data').elem('banners-table').def()(function() {
    var ctx = this.ctx,
        statCtx = this.campStatCtx,
        banners = statCtx.banners || [],
        mods = u._.pick(ctx.elemMods, 'type'),
        firstCellColspan = ctx.firstCellColspan,
        //DIRECT-37905 - кто-то тихой сапой меняет this.ctx.totalCellsLength в процессе перебора баннеров, так что выносим его в переменную
        totalCellsLength = ctx.totalCellsLength,
        withoutPlot = this.ctx.withoutPlot,
        mediaType = statCtx.campaign.mediaType,
        form,
        countPerPage,
        offset;

    // общая обработка для извлечения списка баннеров
    if (!this.ctx.skipSlice && banners.length) {
        form = statCtx.form;

        if (!form.allpages && !statCtx.skipSlice) {
            countPerPage = statCtx.bannersOnPage;
            offset = countPerPage * ((form.page || 1) - 1);

            // Берем только баннеры текущей страницы
            banners = banners.slice(offset, offset + countPerPage);
        }
    }

    // Возвращаем массив элементов tbody (по одному на баннер)
    // В первой строке (title) каждого tbody превью и описание баннера
    return banners.map(function(banner) {
        // в первой строке каждого tbody
        // title строка, в первой ячейке содержащая баннер (превью и информацию)
        var bannerPreviewBlock = {
            block: 'b-stat-table',
            elem: 'title',
            elemMods: {
                'banner-preview': 'yes'
            },
            js: {
                banner: u._.pick(
                    banner,
                    mediaType === 'performance' ? [
                        'bid',
                        'domain',
                        'group_name',
                        'creative'
                    ] : [
                        'bid',
                        'domain',
                        'group_name',
                        'real_banner_type',
                        banner.is_template_banner ? 'templ_title' : 'title',
                        banner.is_template_banner ? 'templ_body' : 'body',
                        banner.is_template_banner ? 'templ_href' : 'href'
                    ]),
                statusOpenStat: statCtx.campaign.statusOpenStat
            },
            cols: [{
                content: {
                    block: 'b-stat-banner',
                    mods: mods,
                    modelParams: {
                        name: u.campaign.getGroupModelName(statCtx.campaign.mediaType),
                        id: banner.adgroup_id
                    },
                    banner: banner,
                    cid: statCtx.cid,

                    // для новых графиков DIRECT-59325
                    chartsManager: !withoutPlot && {
                        cid: statCtx.cid,
                        groupByDate: statCtx.group,
                        withNds: statCtx.withNds,
                        date: statCtx.date
                    }
                },
                attrs: {
                    colspan: totalCellsLength
                }
            }]
        };

        return {
            rows: [bannerPreviewBlock].concat(applyCtx({
                elem: 'table-parts',
                elemMods: mods,
                statData: banner,
                cellsItems: [
                    banner.dates ?
                        {
                            id: 'sorting',
                            title: iget2('b-campaign-stat-data', 'data', 'Дата'),
                            sorting: {
                                params: {
                                    anchor: banner.bid
                                }
                            },
                            hideTargets: true,
                            colspan: firstCellColspan + (this.data.isCpmStat ? 1 : 0)
                        } :
                        {
                            title: '',
                            hideTargets: true,
                            colspan: firstCellColspan + (this.data.isCpmStat ? 1 : 0)
                        }
                ],
                firstCellColspan: firstCellColspan + (this.data.isCpmStat ? 1 : 0)
            }))
        };
    }, this);
});
