block('b-campaign-stat-data').elem('campaign-summary-table').def()(function() {
    var ctx = this.ctx,
        plotLinkLabel = iget2('b-campaign-stat-data', 'pokazat-grafik', 'Показать график'),
        statData = this.ctx.statData || this.campStatCtx.campstat,
        firstCellColspan = this.ctx.firstCellColspan,
        cellsItems = [
            statData.dates ?
            {
                id: 'sorting',
                title: iget2('b-campaign-stat-data', 'data', 'Дата'),
                sorting: {
                    params: {
                        anchor: statData.bid
                    },
                    defaultColumn: 'sorting'
                },
                colspan: firstCellColspan + (this.data.isCpmStat ? 1 : 0),
                hideTargets: true
            } :
            {
                title: '',
                hideTargets: true,
                colspan: firstCellColspan + (this.data.isCpmStat ? 1 : 0)
            }
        ];

    return {
        rows: [{
            elem: 'title',
            cols: [{
                content: {
                    block: 'b-campaign-stat-data',
                    mods: ctx.elemMods,
                    elem: 'table-title',
                    elemMods: ctx.elemMods,
                    showChartHref: statData.dates && statData.dates.length > 0,
                    plotLinkLabel: plotLinkLabel,
                    viewType: this.ctx.viewType,
                    statData: statData,
                        //DIRECT-54001: передаем currency для графиков статистики
                    currency: this.campStatCtx.currency
                },
                attrs: {
                    colspan: this.ctx.totalCellsLength
                }
            }]
        }]
            .concat(applyCtx({
                elem: 'table-parts',
                elemMods: ctx.elemMods,
                statData: statData,
                cellsItems: cellsItems,
                firstCellColspan: firstCellColspan
            }))
    };
});
