block('b-campaign-stat-data').elem('common-cells-by-target').def()(function() {
    var rowData = this.ctx.rowData,
        specPrefix = 'spec_',
        prefix = this.campStatCtx.spec || this.ctx.spec ? specPrefix : '',
        allPrefix = 'all_',
        all = this.campStatCtx.all || this.ctx.all,
        fieldsToFormat = /^(ctr|ectr|sum|fp_shows_avg_pos|fp_clicks_avg_pos|avg_x|av_sum)$/,
        form = this.campStatCtx.form,
        fields = this.ctx.fields,
        fieldsLength = fields.length,
        helpUrl = u.getHelpUrl('more-clicks'),
        formTargets = {
            '': 'target_all',
            _0: 'target_0',
            _1: 'target_1'
        },
        formTargetKeys = Object.keys(formTargets),
        formTargetKeysLength = formTargetKeys.length,
        rowCellsData = [],
        fieldsIterator = 0,
        targetKeysIterator,
        isFieldToFormat,
        field,
        value,
        help,
        suf;

    //Шаблон применяется часто.
    //На больших объёмах данных использование for вместо forEach дает прирост по производительности
    for (; fieldsIterator < fieldsLength; fieldsIterator++) {
        field = fields[fieldsIterator];
        isFieldToFormat = fieldsToFormat.test(field);

        for (targetKeysIterator = 0; targetKeysIterator < formTargetKeysLength; targetKeysIterator++) {
            help = undefined;
            suf = formTargetKeys[targetKeysIterator];

            if (!form[formTargets[suf]]) continue;

            value = rowData[prefix + field + suf];

            if (all && rowData[specPrefix + field + suf]) {
                value += rowData[specPrefix + field + suf];
            }

            if (all && rowData[allPrefix + field + suf] && isFieldToFormat) {
                value = rowData[allPrefix + field + suf];
            }

            if (field == 'ctr' && value > 100) {
                help = {
                    url: helpUrl
                };
                value = '&ndash;';
            } else if (value) {
                value = isFieldToFormat ? u.numberFormatter.format(value, {
                    exponentDelimiter: '&nbsp;'
                }) : value;
            } else {
                value = isFieldToFormat ? '0.00' : '0';
            }

            rowCellsData.push({
                content: value,
                help: help
            });
        }
    }

    return rowCellsData;
});
