block('b-campaign-stat-data').elem('detailed-table').elemMod('type', 'campdate').def()(function() {

    var data = this.data,
        orders = data.orders,
        isFavorites = !!+this.data.show_favorites,
        cellsLength = this.ctx.totalCellsLength,
        tableData = [];

    tableData = tableData.concat(applyCtx({
        elem: 'campaign-summary-table',
        elemMods: {
            type: 'campdate'
        },
        totalCellsLength: cellsLength,
        firstCellColspan: 0,
        statData: data
    }));

    tableData = tableData.concat([
        {
            tbodyMods: {
                type: 'space'
            }
        },
        {
            rows: [{
                elem: 'title',
                cols: [{
                    content: {
                        block: 'b-stat-table',
                        elem: 'campaign-table-title',
                        caption: iget2('b-campaign-stat-data', 'po-kazhdoy-kampanii', 'По каждой кампании')
                    },
                    attrs: {
                        colspan: cellsLength
                    }
                }]
            }]
        }
    ]);

    orders.forEach(function(order) {
        if ((order.shows || order.clicks) && (!isFavorites || (isFavorites && !!order.is_favorite_cid))) {
            tableData = tableData.concat(applyCtx({
                elem: 'campaign-summary-table',
                elemMods: {
                    type: 'campdate'
                },
                viewType: 'campaign',
                totalCellsLength: cellsLength,
                firstCellColspan: 0,
                statData: order
            }), {
                tbodyMods: {
                    type: 'space'
                }
            });
        }
    }, this);

    return tableData;
});
