block('b-campaign-stat-data').elem('detailed-table').elemMod('type', 'custom').def()(function() {
    var groupHash = this.campStatCtx.groupHash,
        additionalFields = [
            'tag',
            'adgroup',
            'banner',
            'page',
            'page_type',
            'position',
            'image',
            'device_type',
            'detailed_device_type',
            'connection_type',
            'gender',
            'age',
            'phrase',
            'performance_filter',
            'geo',
            'date'
        ],
        additionalFieldsTitles = [
            iget2('b-campaign-stat-data', 'metka', 'Метка'),
            iget2('b-campaign-stat-data', 'gruppa', 'Группа'),
            iget2('b-campaign-stat-data', 'no-obyavleniya', '№ объявления'),
            iget2('b-campaign-stat-data', 'ploshchadka', 'Площадка'),
            iget2('b-campaign-stat-data', 'tip-ploshchadki', 'Тип площадки'),
            iget2('b-campaign-stat-data', 'placement-type', 'Вид размещения'),
            iget2('b-campaign-stat-data', 'izobrazhenie', 'Изображение'),
            iget2('b-campaign-stat-data', 'tip-ustroystva', 'Тип устройства'),
            iget2('b-campaign-stat-data', 'tip-operacionnoy-sistemy', 'Тип операционной системы'),
            iget2('b-campaign-stat-data', 'tip-svyazi', 'Тип связи'),
            iget2('b-campaign-stat-data', 'pol', 'Пол'),
            iget2('b-campaign-stat-data', 'vozrast', 'Возраст'),
            iget2('b-campaign-stat-data', 'fraza', 'Фраза'),
            iget2('b-campaign-stat-data', 'filtr', 'Фильтр'),
            iget2('b-campaign-stat-data', 'region', 'Регион'),
            iget2('b-campaign-stat-data', 'data', 'Дата')
        ],
        cellsItems = [];

    additionalFields.forEach(function(field, i) {
        var cell = {
            id: field == 'page_type' ? undefined : field,
            title: additionalFieldsTitles[i],
            sorting: {
                params: {
                    defaultReverse: 1
                }
            },
            hideTargets: true,
            elemMods: {
                type: 'reports-wizard-cell'
            }
        };

        if (cell.id) {
            cell.id == 'phrase' ?
                (groupHash['phrase'] || groupHash['retargeting'] || groupHash['dynamic']) && cellsItems.push(cell) :
                groupHash[cell.id] && cellsItems.push(cell);
        } else {
            groupHash['page'] && cellsItems.push(cell);
        }
    }, this);

    cellsItems[0].colspan = applyCtx({
        elem: 'detailed-table-first-cell-colspan'
    });

    return {
        rows: (applyCtx({
            elem: 'table-head',
            cellsItems: cellsItems
        }) || [])
            .concat(this.campStatCtx.dataArray.map(function(rowData) {
                return {
                    cols: applyCtx({
                        elem: 'row',
                        rowData: rowData,
                        additionalFields: {
                            names: additionalFields,
                            elemName: 'reports-wizard-cells'
                        }
                    })
                };
            }, this))
    };
});
