// блок генерирует данные для вкладки со статистикой по регионам
// в зависимости от значения this.data.FORM.show_banners_stat
// страница принимает вид списка регионо (!=1)
// или с группировкой по баннерам (==1)
// так же таблица регионов может иметь древовидную структуру или просто список
// data.regions

block('b-campaign-stat-data').elem('detailed-table').elemMod('type', 'geo').def()(function() {

    var campStatCtx = this.campStatCtx, // контекст переданый блоков p-campaign-stat в b-campaign-stat-data
        banners = campStatCtx.banners,
        firstCellColspan = this.targetsLength + 1,
        tableData = [];

    if ((!banners || banners.length > 1) && this.campStatCtx.campstat) {
        tableData = tableData.concat(applyCtx({
            elem: 'campaign-summary-table',
            totalCellsLength: this.ctx.totalCellsLength,
            firstCellColspan: firstCellColspan
        }));
    }

    // Если нужна подробная статистика по баннера, то показываем ее
    if (this.campStatCtx.form.show_banners_stat) {

        tableData = tableData.concat(applyCtx({
            elem: 'banners-table',
            elemMods: {
                type: 'geo'
            },
            totalCellsLength: this.ctx.totalCellsLength,
            firstCellColspan: firstCellColspan
        }));
    } else if (this.data.regions) {
        // иначе показываем список регионов для кампании просто
        tableData = {
            tbodyMods: {
                type: 'geo'
            },
            rows: applyCtx({
                elem: 'table-parts',
                elemMods: {
                    type: 'geo'
                },
                statData: this.data
            })
        };
    }

    return tableData;
});
