block('b-campaign-stat-data').elem('detailed-table').elemMod('type', 'phrase-detail').def()(function() {

    var campStat = this.campStatCtx,
        statusOpenStat = campStat.campaign.statusOpenStat,
        cid = campStat.cid,
        firstCellColspan = this.targetsLength + 1,
        totalCellsLength = this.ctx.totalCellsLength,
        elemMods = this.ctx.elemMods,
        mediaType = campStat.campaign.mediaType;

    // Возвращаем массив элементов tbody (по одному на баннер)
    // В первой строке (title) каждого tbody превью и описание баннера
    return campStat.banners.map(function(banner) {
        var rows = ['table-head', 'table-body', 'table-foot'].reduce(function(res, name, i) {
            var el = {
                elem: name,
                elemMods: elemMods,
                statData: banner
            };

            !i && (el.cellsItems = u._.compact([
                {
                    title: u.campaign.getPhraseDetailStatFirstColTitle(mediaType),
                    hideTargets: true
                },
                this.data.isCpmStat && {
                    title: iget2('b-campaign-stat-data', 'show-condition-type', 'Тип условия показа'),
                    hideTargets: true
                },
                {
                    id: 'date',
                    title: iget2('b-campaign-stat-data', 'data', 'Дата'),
                    sorting: {
                        params: {
                            anchor: banner.bid
                        }
                    },
                    hideTargets: true,
                    colspan: firstCellColspan - 1
                }
            ]));

            el.firstCellColspan = firstCellColspan;

            return res.concat(applyCtx(el));
        }.bind(this), []);

        return {
            rows: [
                // в первой строке каждого tbody
                // title строка, в первой ячейке содержащая баннер (превью и информацию)
                {
                    block: 'b-stat-table',
                    elem: 'title',
                    elemMods: {
                        'banner-preview': 'yes'
                    },
                    js: {
                        banner: u._.pick(
                            banner,
                            mediaType == 'performance' ? [
                                'bid',
                                'domain',
                                'group_name',
                                'creative'
                            ] : [
                                'bid',
                                'domain',
                                'group_name',
                                'real_banner_type',
                                banner.is_template_banner ? 'templ_title' : 'title',
                                banner.is_template_banner ? 'templ_body' : 'body',
                                banner.is_template_banner ? 'templ_href' : 'href'
                            ]),
                        statusOpenStat: statusOpenStat
                    },
                    cols: [{
                        content: {
                            block: 'b-stat-banner',
                            modelParams: {
                                name: u.campaign.getGroupModelName(mediaType),
                                id: banner.adgroup_id
                            },
                            banner: banner,
                            cid: cid
                        },
                        attrs: {
                            colspan: totalCellsLength
                        }
                    }]
                }
            ].concat(rows)
        };
    }.bind(this));
});
