block('b-campaign-stat-data').elem('detailed-table').elemMod('type', 'platform').def()(function() {
    var firstCellColspan = this.targetsLength + 1 + (this.data.isCpmStat ? 1 : 0),
        campStatCtx = this.campStatCtx,
        blockedMassActions = campStatCtx.blockedMassActions,
        dataArray = campStatCtx.dataArray,
        detailed = campStatCtx.detailed,
        headRows = applyCtx({
            elem: 'table-head',
            cellsItems: [
                {
                    id: 'sorting',
                    title: iget2('b-campaign-stat-data', 'ploshchadka', 'Площадка'),
                    hideTargets: true,
                    sorting: {
                        params: {
                            defaultReverse: 0
                        },
                        defaultColumn: 'sorting'
                    },
                    colspan: firstCellColspan
                }
            ]
        }),
        rows = (applyCtx(dataArray.map(function(rowData) {
            return {
                elem: 'row',
                rowData: rowData
            };
        })) || [])
        .map(function(cols, index) {
            var rowData = dataArray[index],
                name = rowData.name,
                pageName = name,
                pageDomain = rowData.page_domain,
                disabled = rowData.is_disabled || rowData.is_video_disabled,
                canBeDisabled = rowData.can_be_disabled,
                isCpmBannerOnly = this.data.mediaType === 'cpm_banner',
                firstCellContent = {
                    block: 'b-stat-table',
                    elem: 'blocks-wrap-within-cached-row',
                    content: [{
                        block: 'b-stat-table',
                        elem: 'additional-controls',
                        elemMods: {
                            type: 'platform',
                            disabled: disabled ? 'yes' : ''
                        },
                        isCpmStat: this.data.isCpmStat,
                        mediaType: this.data.mediaType,
                        statData: rowData,
                        hrefParams: campStatCtx.hrefParams,
                        disabled: disabled,
                        detailed: detailed,
                        pageName: pageName,
                        pageDomain: pageDomain,

                        content: [
                                    // проверка на то, является ли площадка обычной
                                    // для спец площадок значение page_sorting меньше 9
                                    // для обычных площадок доступны групповые действия
                            (rowData.page_sorting === 9 ||
                                this.data.features_enabled_for_client.disable_any_domains_allowed) &&
                                (canBeDisabled || disabled) ?
                            {
                                block: 'checkbox',
                                mods: {
                                    size: 's',
                                    disabled: blockedMassActions ? 'yes' : ''
                                },
                                mix: [
                                    {
                                        block: 'b-checkboxes-group',
                                        elem: 'item'
                                    },
                                    {
                                        block: 'b-stat-table',
                                        elem: 'checkbox'
                                    },
                                    {
                                        block: 'b-stat-table',
                                        elem: 'additional-controls-checkbox'
                                    }
                                ],
                                checkboxAttrs: {
                                    value: rowData.page_domain
                                }
                            } :
                            '',
                            {
                                block: 'spin',
                                mix: [{
                                    block: 'b-stat-table',
                                    elem: 'spin'
                                }],
                                js: true,
                                mods: {
                                    theme: 'gray-16'
                                }
                            },
                            {
                                block: 'link',
                                mods: {
                                    pseudo: 'yes',
                                    inner: 'yes'
                                },
                                mix: [{
                                    block: 'b-stat-table',
                                    elem: 'expand-link'
                                }],
                                content: {
                                    block: 'icon',
                                    mods: {
                                        type: 'plus'
                                    },
                                    mix: [{
                                        block: 'b-stat-table',
                                        elem: 'expand-icon'
                                    }]
                                }
                            }
                        ]
                    }]
                };

            if (!/^(yandex|yacatalog)$/.test(rowData.page_group)) {
                pageName = {
                    block: 'link',
                    mix: [{
                        block: 'b-stat-table',
                        elem: 'cell-link'
                    }],
                    url: 'http://' + (rowData.page_domain || pageName),
                    target: '_blank',
                    content: pageName
                };
            }

            firstCellContent.content.push(pageName);

            rowData.TargetType === 3 &&
                firstCellContent.content.push('&nbsp;(', iget2('b-campaign-stat-data', 'seti', 'сети'), ')');

            detailed &&
                firstCellContent.content.push(
                    '&nbsp;',
                    rowData.page_id,
                    '&nbsp;&ndash;&nbsp;',
                    rowData.page_domain);

            isCpmBannerOnly &&
                firstCellContent.content.push({
                    elem: 'black-list',
                    blockedMassActions: blockedMassActions,
                    index: index,
                    pageName: name,
                    disabled: rowData.is_disabled,
                    videoDisabled: rowData.is_video_disabled,
                    // TODO: DIRECT-99054 — расскоментировать для Аудио
                    //audioDisabled: rowData.is_audio_disabled
                });

            cols.unshift({
                content: firstCellContent,
                attrs: {
                    colspan: firstCellColspan
                }
            });

            return {
                rows: [
                    {
                        cols: cols,
                        elemMods: {
                            disabled: disabled ? 'yes' : '',
                            holiday: rowData.holiday ? 'yes' : ''
                        },
                        cacheKey: 'platform-row'
                    }
                ]
            };
        }, this);

    return [{
        rows: headRows
    }].concat(rows);
});
