block('b-campaign-stat-data').elem('detailed-table').def()(function() {
    var ctx = this.ctx,
        statCtx = this.campStatCtx,
        banners = statCtx.banners,
        firstCellColspan = this.targetsLength + 1,
        totalCellsLength = ctx.totalCellsLength,
        mods = u._.pick(ctx.elemMods, 'type'),
        tableData = [];

    // во вкладке "мастер отчетов" мы можем вывести статистику по одному банеру (указав в форме номер объявления).
    // для этого случая не показываем статистику кампании
    if (statCtx.campstat && statCtx.plotGroup && (banners || []).length != 1) {
        tableData = tableData.concat(applyCtx({
            elem: 'campaign-summary-table',
            elemMods: mods,
            totalCellsLength: totalCellsLength,
            firstCellColspan: firstCellColspan
        }));
    }

    if (statCtx.form.show_banners_stat) {
        tableData = tableData.concat(applyCtx({
            elem: 'banners-table',
            elemMods: mods,
            totalCellsLength: totalCellsLength,
            firstCellColspan: firstCellColspan
        }));
    }

    return tableData;
});
