// определяет основные ячейки таблицы для статистики по фразам (смарт: условия показа по дням)
block('b-campaign-stat-data').elem('head-field-set').elemMod('type', 'phrase-detail').def()(function() {
    var formattedCurrency = this.ctx.formattedCurrency,
        isCpmStat = this.data.isCpmStat,
        showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.data.mediaType);

    // DIRECT-58847: показы и ctr для Смартов считаются неверно,
    // поэтому их убрали из статистики
    return this.ctx.mediaType === 'performance' ? [
        {
            id: 'clicks',
            title: iget2('b-campaign-stat-data', 'kliki', 'Клики')
        },
        {
            id: 'sum',
            title: iget2('b-campaign-stat-data', 'rashod-vsego', 'Расход всего') + formattedCurrency
        },
        {
            id: 'av_sum',
            title: iget2('b-campaign-stat-data', 'sr-cena-klika-currency', 'Ср. цена клика, {currency}', {
                currency: this.currency,
                context: 'currency - у.е.'
            })
        }
    ] : u._.compact([
        {
            id: 'shows',
            title: iget2('b-campaign-stat-data', 'pokazy', 'Показы')
        },
        showTrafficVolumeStatFields && {
            id: 'eshows',
            title: iget2('b-campaign-stat-data', 'eshows', 'Взвешенные показы')
        },
        {
            id: 'clicks',
            title: iget2('b-campaign-stat-data', 'kliki', 'Клики')
        },
        {
            id: 'ctr',
            title: iget2('b-campaign-stat-data', 'ctr', 'CTR') + ' (%)'
        },
        showTrafficVolumeStatFields && {
            id: 'ectr',
            title: iget2('b-campaign-stat-data', 'wctr', 'wCTR') + ' (%)'
        },
        {
            id: 'sum',
            title: iget2('b-campaign-stat-data', 'rashod-vsego', 'Расход всего') + formattedCurrency
        },
        isCpmStat && {
            id: 'avg_cpm',
            title: iget2('b-campaign-stat-data', 'sr-cena-tisachi-pokazov', 'Ср. цена тысячи показов') + formattedCurrency
        },
        {
            id: 'av_sum',
            title: iget2('b-campaign-stat-data', 'sr-cena-klika-currency', 'Ср. цена клика, {currency}', {
                currency: this.currency,
                context: 'currency - у.е.'
            })
        }
    ]);
});
