block('b-campaign-stat-data').elem('header-cells').def()(function() {

    var data = this.data,
        cellData = [],
        targetLabels = [],
        form = this.campStatCtx.form,
        cellOptions = this.ctx.cellOptions || {},
        mods = cellOptions.mods || {},
        hideTargets = cellOptions.hideTargets,
        column = cellOptions.column,
        sorting = cellOptions.sorting,
        defaultColumn = sorting.defaultColumn,
        sortingParams = sorting.params,
        colspan = cellOptions.colspan,
        targets = this.targets,
        attrs = {
            colspan: colspan || this.targetsLength
        };

    hideTargets || (mods.align = 'right');

    if (this.targetsLength > 1 && !hideTargets) {
        cellData.push(column.title, '<br />');

        form.target_all && targetLabels.push(
            data.getMemoizedSortTableHeader({
                broadcast: true,
                script: data.script,
                col: column.id,
                caption: targets[0],
                defCol: defaultColumn,
                options: sortingParams
            }, form));

        form.target_0 && targetLabels.push(
            data.getMemoizedSortTableHeader({
                broadcast: true,
                script: data.script,
                col: column.id + '_0',
                caption: targets[1],
                defCol: defaultColumn,
                options: sortingParams
            }, form));

        form.target_1 && targetLabels.push(
            data.getMemoizedSortTableHeader({
                broadcast: true,
                script: data.script,
                col: column.id + '_1',
                caption: targets[2],
                defCol: defaultColumn,
                options: sortingParams
            }, form));

        cellData.push(u.spacer(targetLabels, ' / '));
    } else {
        column.id ?
            cellData.push(data.getMemoizedSortTableHeader({
                broadcast: true,
                script: data.script,
                col: column.id,
                caption: column.title,
                defCol: defaultColumn,
                options: sortingParams
            }, form)) :
            cellData.push(column.title);

        !colspan && (attrs = undefined);
    }

    return {
        content: cellData,
        attrs: attrs,
        elemMods: mods
    };
});
